/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.BaseConnectionFactory;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C3P0ConnectionFactory
extends BaseConnectionFactory {
    public static final Logger LOG = LoggerFactory.getLogger(C3P0ConnectionFactory.class);
    private ComboPooledDataSource m_pool;

    public C3P0ConnectionFactory(JdbcDataSource dataSource) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(dataSource);
    }

    @Override
    protected void initializePool(JdbcDataSource dataSource) throws SQLException {
        this.m_pool = new ComboPooledDataSource();
        this.m_pool.setPassword(dataSource.getPassword());
        this.m_pool.setUser(dataSource.getUserName());
        this.m_pool.setJdbcUrl(dataSource.getUrl());
        try {
            this.m_pool.setDriverClass(dataSource.getClassName());
        }
        catch (PropertyVetoException e) {
            throw new SQLException("Unable to set driver class.", e);
        }
        Properties properties = new Properties();
        for (Param parameter : dataSource.getParamCollection()) {
            properties.put(parameter.getName(), parameter.getValue());
        }
        if (!properties.isEmpty()) {
            this.m_pool.setProperties(properties);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_pool.getConnection();
    }

    @Override
    public String getUrl() {
        return this.m_pool.getJdbcUrl();
    }

    @Override
    public void setUrl(String url) {
        C3P0ConnectionFactory.validateJdbcUrl(url);
        this.m_pool.setJdbcUrl(url);
    }

    @Override
    public String getUser() {
        return this.m_pool.getUser();
    }

    @Override
    public void setUser(String user) {
        this.m_pool.setUser(user);
    }

    @Override
    public DataSource getDataSource() {
        return this.m_pool;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_pool.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pool.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_pool.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_pool.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_pool.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    @Override
    public void close() {
        super.close();
        LOG.info("Closing C3P0 pool.");
        this.m_pool.close();
    }

    @Override
    public void setIdleTimeout(int idleTimeout) {
        this.m_pool.setMaxIdleTime(idleTimeout);
    }

    @Override
    public void setMinPool(int minPool) {
        this.m_pool.setMinPoolSize(minPool);
    }

    @Override
    public void setMaxPool(int maxPool) {
        this.m_pool.setMaxPoolSize(maxPool);
    }

    @Override
    public void setMaxSize(int maxSize) {
        LOG.debug("C3P0 has no equivalent to setMaxSize(). Ignoring.");
    }
}

