/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.filter.Column;
import org.opennms.netmgt.config.filter.Join;

@XmlRootElement(name="table")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Table
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_VISIBLE = "true";
    private static final String DEFAULT_KEY = "secondary";
    @XmlAttribute(name="visible")
    private String visible;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="key")
    private String key;
    @XmlElement(name="join")
    private List<Join> joinList = new ArrayList<Join>();
    @XmlElement(name="column", required=true)
    private List<Column> columnList = new ArrayList<Column>();

    public void addColumn(Column vColumn) throws IndexOutOfBoundsException {
        this.columnList.add(vColumn);
    }

    public void addColumn(int index, Column vColumn) throws IndexOutOfBoundsException {
        this.columnList.add(index, vColumn);
    }

    public void addJoin(Join vJoin) throws IndexOutOfBoundsException {
        this.joinList.add(vJoin);
    }

    public void addJoin(int index, Join vJoin) throws IndexOutOfBoundsException {
        this.joinList.add(index, vJoin);
    }

    public Enumeration<Column> enumerateColumn() {
        return Collections.enumeration(this.columnList);
    }

    public Enumeration<Join> enumerateJoin() {
        return Collections.enumeration(this.joinList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Table) {
            Table temp = (Table)obj;
            boolean equals = Objects.equals(temp.visible, this.visible) && Objects.equals(temp.name, this.name) && Objects.equals(temp.key, this.key) && Objects.equals(temp.joinList, this.joinList) && Objects.equals(temp.columnList, this.columnList);
            return equals;
        }
        return false;
    }

    public Column getColumn(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.columnList.size()) {
            throw new IndexOutOfBoundsException("getColumn: Index value '" + index + "' not in range [0.." + (this.columnList.size() - 1) + "]");
        }
        return this.columnList.get(index);
    }

    public Column[] getColumn() {
        Column[] array = new Column[]{};
        return this.columnList.toArray(array);
    }

    public List<Column> getColumnCollection() {
        return this.columnList;
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public Join getJoin(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.joinList.size()) {
            throw new IndexOutOfBoundsException("getJoin: Index value '" + index + "' not in range [0.." + (this.joinList.size() - 1) + "]");
        }
        return this.joinList.get(index);
    }

    public Join[] getJoin() {
        Join[] array = new Join[]{};
        return this.joinList.toArray(array);
    }

    public List<Join> getJoinCollection() {
        return this.joinList;
    }

    public int getJoinCount() {
        return this.joinList.size();
    }

    public String getKey() {
        return this.key != null ? this.key : DEFAULT_KEY;
    }

    public String getName() {
        return this.name;
    }

    public String getVisible() {
        return this.visible != null ? this.visible : DEFAULT_VISIBLE;
    }

    public int hashCode() {
        int hash = Objects.hash(this.visible, this.name, this.key, this.joinList, this.columnList);
        return hash;
    }

    public Iterator<Column> iterateColumn() {
        return this.columnList.iterator();
    }

    public Iterator<Join> iterateJoin() {
        return this.joinList.iterator();
    }

    public void removeAllColumn() {
        this.columnList.clear();
    }

    public void removeAllJoin() {
        this.joinList.clear();
    }

    public boolean removeColumn(Column vColumn) {
        boolean removed = this.columnList.remove(vColumn);
        return removed;
    }

    public Column removeColumnAt(int index) {
        Column obj = this.columnList.remove(index);
        return obj;
    }

    public boolean removeJoin(Join vJoin) {
        boolean removed = this.joinList.remove(vJoin);
        return removed;
    }

    public Join removeJoinAt(int index) {
        Join obj = this.joinList.remove(index);
        return obj;
    }

    public void setColumn(int index, Column vColumn) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.columnList.size()) {
            throw new IndexOutOfBoundsException("setColumn: Index value '" + index + "' not in range [0.." + (this.columnList.size() - 1) + "]");
        }
        this.columnList.set(index, vColumn);
    }

    public void setColumn(Column[] vColumnArray) {
        this.columnList.clear();
        for (int i = 0; i < vColumnArray.length; ++i) {
            this.columnList.add(vColumnArray[i]);
        }
    }

    public void setColumn(List<Column> vColumnList) {
        this.columnList.clear();
        this.columnList.addAll(vColumnList);
    }

    public void setColumnCollection(List<Column> columnList) {
        this.columnList = columnList;
    }

    public void setJoin(int index, Join vJoin) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.joinList.size()) {
            throw new IndexOutOfBoundsException("setJoin: Index value '" + index + "' not in range [0.." + (this.joinList.size() - 1) + "]");
        }
        this.joinList.set(index, vJoin);
    }

    public void setJoin(Join[] vJoinArray) {
        this.joinList.clear();
        for (int i = 0; i < vJoinArray.length; ++i) {
            this.joinList.add(vJoinArray[i]);
        }
    }

    public void setJoin(List<Join> vJoinList) {
        this.joinList.clear();
        this.joinList.addAll(vJoinList);
    }

    public void setJoinCollection(List<Join> joinList) {
        this.joinList = joinList;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }
}

