/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.HideMatch;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.HostaddrMatch;
import org.opennms.netmgt.config.syslogd.HostnameMatch;
import org.opennms.netmgt.config.syslogd.ParameterAssignment;
import org.opennms.netmgt.config.syslogd.ProcessMatch;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.opennms.netmgt.dao.api.AbstractInterfaceToNodeCache;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToEvent {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertToEvent.class);
    protected static final String HIDDEN_MESSAGE = "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.";
    private final Event m_event;
    private static final LoadingCache<String, Pattern> CACHED_PATTERNS = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String expression) {
            try {
                return Pattern.compile(expression, 8);
            }
            catch (PatternSyntaxException e) {
                LOG.warn("Failed to compile regex pattern '{}'", (Object)expression, (Object)e);
                return null;
            }
        }
    });

    public ConvertToEvent(String systemId, String location, DatagramPacket packet, SyslogdConfig config) throws UnsupportedEncodingException, MessageDiscardedException {
        this(systemId, location, packet.getAddress(), packet.getPort(), new String(packet.getData(), 0, packet.getLength(), "US-ASCII"), config);
    }

    public ConvertToEvent(String systemId, String location, InetAddress addr, int port, String data, SyslogdConfig config) throws UnsupportedEncodingException, MessageDiscardedException {
        EventBuilder bldr;
        String facilityTxt;
        String priorityTxt;
        SyslogMessage message;
        block24: {
            List hideMatch;
            boolean doHide;
            String fullText;
            Matcher msgMat;
            Pattern msgPat;
            block23: {
                List ueiMatch;
                SyslogParser parser;
                if (config == null) {
                    throw new IllegalArgumentException("Config cannot be null");
                }
                UeiList ueiList = config.getUeiList();
                HideMessage hideMessage = config.getHideMessages();
                String discardUei = config.getDiscardUei();
                String syslogString = data.endsWith("\u0000") ? data.substring(0, data.length() - 1) : data;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Converting to event: {}", (Object)this);
                }
                if (!(parser = SyslogParser.getParserInstance(config, syslogString)).find()) {
                    throw new MessageDiscardedException("message does not match");
                }
                try {
                    message = parser.parse();
                }
                catch (SyslogParserException ex) {
                    LOG.debug("Unable to parse '{}'", (Object)syslogString, (Object)ex);
                    throw new MessageDiscardedException(ex);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("got syslog message {}", (Object)message);
                }
                if (message == null) {
                    throw new MessageDiscardedException(String.format("Unable to parse '%s'", syslogString));
                }
                priorityTxt = message.getSeverity().toString();
                facilityTxt = message.getFacility().toString();
                bldr = new EventBuilder("uei.opennms.org/syslogd/" + facilityTxt + "/" + priorityTxt, "syslogd");
                bldr.setDistPoller(systemId);
                bldr.setTime(message.getDate());
                bldr.setHost(InetAddressUtils.getLocalHostName());
                InetAddress hostAddress = message.getHostAddress();
                if (hostAddress != null) {
                    int nodeId = AbstractInterfaceToNodeCache.getInstance().getNodeId(location, hostAddress);
                    if (nodeId > 0) {
                        bldr.setNodeid((long)nodeId);
                    }
                    bldr.setInterface(hostAddress);
                }
                bldr.setLogDest("logndisplay");
                msgPat = null;
                msgMat = null;
                fullText = message.getFullText();
                String matchedText = message.getMatchedMessage();
                List list = ueiMatch = ueiList == null ? null : ueiList.getUeiMatchCollection();
                if (ueiMatch == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No ueiList configured.");
                    }
                } else {
                    UeiMatch uei;
                    boolean otherStuffMatches;
                    Iterator iterator = ueiMatch.iterator();
                    while (!(!iterator.hasNext() || (otherStuffMatches = ConvertToEvent.containsIgnoreCase((uei = (UeiMatch)iterator.next()).getFacilityCollection(), facilityTxt) && ConvertToEvent.containsIgnoreCase(uei.getSeverityCollection(), priorityTxt) && ConvertToEvent.matchProcess(uei.getProcessMatch(), message.getProcessName()) && ConvertToEvent.matchHostname(uei.getHostnameMatch(), message.getHostName()) && ConvertToEvent.matchHostAddr(uei.getHostaddrMatch(), InetAddressUtils.str((InetAddress)hostAddress))) && (uei.getMatch().getType().equals("substr") ? ConvertToEvent.matchSubstring(discardUei, bldr, matchedText, uei) : uei.getMatch().getType().startsWith("regex") && ConvertToEvent.matchRegex(message, uei, bldr, discardUei)))) {
                    }
                }
                doHide = false;
                List list2 = hideMatch = hideMessage == null ? null : hideMessage.getHideMatchCollection();
                if (hideMatch != null) break block23;
                if (!LOG.isDebugEnabled()) break block24;
                LOG.debug("No hideMessage configured.");
                break block24;
            }
            for (HideMatch hide : hideMatch) {
                if (hide.getMatch().getType().equals("substr")) {
                    if (fullText.contains(hide.getMatch().getExpression())) {
                        doHide = true;
                    }
                } else if (hide.getMatch().getType().equals("regex")) {
                    try {
                        msgPat = Pattern.compile(hide.getMatch().getExpression(), 8);
                        msgMat = msgPat.matcher(fullText);
                    }
                    catch (PatternSyntaxException pse) {
                        LOG.warn("Failed to compile regex pattern '{}'", (Object)hide.getMatch().getExpression(), (Object)pse);
                        msgMat = null;
                    }
                    if (msgMat != null && msgMat.find()) {
                        doHide = true;
                    }
                }
                if (!doHide) continue;
                LOG.debug("Hiding syslog message from Event - May contain sensitive data");
                message.setMessage(HIDDEN_MESSAGE);
                break;
            }
        }
        bldr.setLogMessage(message.getMessage());
        bldr.addParam("syslogmessage", message.getMessage());
        bldr.addParam("severity", "" + priorityTxt);
        bldr.addParam("timestamp", message.getSyslogFormattedDate());
        if (message.getProcessName() != null) {
            bldr.addParam("process", message.getProcessName());
        }
        bldr.addParam("service", "" + facilityTxt);
        if (message.getProcessId() != null) {
            bldr.addParam("processid", message.getProcessId().toString());
        }
        this.m_event = bldr.getEvent();
    }

    private static boolean matchFind(String expression, String input, String context) {
        Pattern pat = ConvertToEvent.getPattern(expression);
        if (pat == null) {
            LOG.debug("Unable to get pattern for expression '{}' in {} context", (Object)expression, (Object)context);
            return false;
        }
        Matcher mat = pat.matcher(input);
        return mat != null && mat.find();
    }

    private static boolean matchHostAddr(HostaddrMatch hostaddrMatch, String hostAddress) {
        if (hostaddrMatch == null) {
            return true;
        }
        if (hostAddress == null) {
            return false;
        }
        String expression = hostaddrMatch.getExpression();
        if (ConvertToEvent.matchFind(expression, hostAddress, "hostaddr-match")) {
            LOG.trace("Successful regex hostaddr-match for input '{}' against expression '{}'", (Object)hostAddress, (Object)expression);
            return true;
        }
        return false;
    }

    private static boolean matchHostname(HostnameMatch hostnameMatch, String hostName) {
        if (hostnameMatch == null) {
            return true;
        }
        if (hostName == null) {
            return false;
        }
        String expression = hostnameMatch.getExpression();
        if (ConvertToEvent.matchFind(expression, hostName, "hostname-match")) {
            LOG.trace("Successful regex hostname-match for input '{}' against expression '{}'", (Object)hostName, (Object)expression);
            return true;
        }
        return false;
    }

    private static boolean matchProcess(ProcessMatch processMatch, String processName) {
        if (processMatch == null) {
            return true;
        }
        if (processName == null) {
            return false;
        }
        String expression = processMatch.getExpression();
        if (ConvertToEvent.matchFind(expression, processName, "process-match")) {
            LOG.trace("Successful regex process-match for input '{}' against expression '{}'", (Object)processName, (Object)expression);
            return true;
        }
        return false;
    }

    private static boolean containsIgnoreCase(List<String> collection, String match) {
        if (collection.size() == 0) {
            return true;
        }
        for (String string : collection) {
            if (!string.equalsIgnoreCase(match)) continue;
            return true;
        }
        return false;
    }

    private static Pattern getPattern(String expression) {
        return (Pattern)CACHED_PATTERNS.getUnchecked((Object)expression);
    }

    private static boolean matchSubstring(String discardUei, EventBuilder bldr, String message, UeiMatch uei) throws MessageDiscardedException {
        boolean doIMatch = false;
        boolean traceEnabled = LOG.isTraceEnabled();
        if (message.contains(uei.getMatch().getExpression())) {
            if (discardUei.equals(uei.getUei())) {
                if (traceEnabled) {
                    LOG.trace("Specified UEI '{}' is same as discard-uei, discarding this message.", (Object)uei.getUei());
                }
                throw new MessageDiscardedException();
            }
            if (traceEnabled) {
                LOG.trace("Changed the UEI of a Syslogd event, based on substring match, to : {}", (Object)uei.getUei());
            }
            bldr.setUei(uei.getUei());
            doIMatch = true;
        } else if (traceEnabled) {
            LOG.trace("No substring match for text of a Syslogd event to : {}", (Object)uei.getMatch().getExpression());
        }
        return doIMatch;
    }

    private static boolean matchRegex(SyslogMessage message, UeiMatch uei, EventBuilder bldr, String discardUei) throws MessageDiscardedException {
        boolean traceEnabled = LOG.isTraceEnabled();
        String expression = uei.getMatch().getExpression();
        Pattern msgPat = ConvertToEvent.getPattern(expression);
        if (msgPat == null) {
            LOG.debug("Unable to create pattern for expression '{}'", (Object)expression);
            return false;
        }
        String text = message.getMatchedMessage() != null ? message.getMatchedMessage() : message.getFullText();
        Matcher msgMat = msgPat.matcher(text);
        if (msgMat != null && msgMat.find()) {
            if (discardUei.equals(uei.getUei())) {
                LOG.debug("Specified UEI '{}' is same as discard-uei, discarding this message.", (Object)uei.getUei());
                throw new MessageDiscardedException();
            }
            bldr.setUei(uei.getUei());
            if (msgMat.groupCount() > 0) {
                if (uei.getMatch().isDefaultParameterMapping()) {
                    if (traceEnabled) {
                        LOG.trace("Doing default parameter mappings for this regex match.");
                    }
                    for (int groupNum = 1; groupNum <= msgMat.groupCount(); ++groupNum) {
                        if (traceEnabled) {
                            LOG.trace("Added parm 'group{}' with value '{}' to Syslogd event based on regex match group", (Object)groupNum, (Object)msgMat.group(groupNum));
                        }
                        bldr.addParam("group" + groupNum, msgMat.group(groupNum));
                    }
                }
                if (uei.getParameterAssignmentCount() > 0) {
                    if (traceEnabled) {
                        LOG.trace("Doing user-specified parameter assignments for this regex match.");
                    }
                    for (ParameterAssignment assignment : uei.getParameterAssignmentCollection()) {
                        String parmName = assignment.getParameterName();
                        String parmValue = msgMat.group(assignment.getMatchingGroup());
                        parmValue = parmValue == null ? "" : parmValue;
                        bldr.addParam(parmName, parmValue);
                        if (!traceEnabled) continue;
                        LOG.trace("Added parm '{}' with value '{}' to Syslogd event based on user-specified parameter assignment", (Object)parmName, (Object)parmValue);
                    }
                }
            }
            return true;
        }
        if (traceEnabled) {
            LOG.trace("Message '{}' did not regex-match pattern '{}'", (Object)message.getMessage(), (Object)expression);
        }
        return false;
    }

    public Event getEvent() {
        return this.m_event;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Event", (Object)this.m_event).toString();
    }
}

