/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.common;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.common.AbstractMessageDispatcherFactory;

public class DispatcherState<W, S extends Message, T extends Message>
implements AutoCloseable {
    private final SinkModule<S, T> module;
    private final W metadata;
    private final MetricRegistry metrics;
    private final Timer dispatchTimer;

    public DispatcherState(AbstractMessageDispatcherFactory<W> dispatcherFactory, SinkModule<S, T> module) {
        this.module = module;
        this.metadata = dispatcherFactory.getModuleMetadata(module);
        this.metrics = dispatcherFactory.getMetrics();
        this.dispatchTimer = this.metrics.timer(MetricRegistry.name((String)module.getId(), (String[])new String[]{"dispatch"}));
    }

    public SinkModule<S, T> getModule() {
        return this.module;
    }

    public W getMetaData() {
        return this.metadata;
    }

    protected MetricRegistry getMetrics() {
        return this.metrics;
    }

    public Timer getDispatchTimer() {
        return this.dispatchTimer;
    }

    @Override
    public void close() throws Exception {
        final String prefix = MetricRegistry.name((String)this.module.getId(), (String[])new String[0]);
        this.metrics.removeMatching(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return name.startsWith(prefix);
            }
        });
    }
}

