/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.best;

import java.net.InetAddress;
import java.util.List;
import org.opennms.netmgt.icmp.NullPinger;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.best.BestMatchPingerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestMatchPinger
implements Pinger {
    private static final Logger LOG = LoggerFactory.getLogger(BestMatchPinger.class);
    private Pinger m_pinger = null;
    private Boolean m_allowFragmentation;
    private Integer m_trafficClass;

    public void ping(InetAddress host, long timeout, int retries, int packetsize, int sequenceId, PingResponseCallback cb) throws Exception {
        this.initialize();
        this.m_pinger.ping(host, timeout, retries, packetsize, sequenceId, cb);
    }

    public void ping(InetAddress host, long timeout, int retries, int sequenceId, PingResponseCallback cb) throws Exception {
        this.initialize();
        this.m_pinger.ping(host, timeout, retries, sequenceId, cb);
    }

    public Number ping(InetAddress host, long timeout, int retries, int packetsize) throws Exception {
        this.initialize();
        return this.m_pinger.ping(host, timeout, retries, packetsize);
    }

    public Number ping(InetAddress host, long timeout, int retries) throws Exception {
        this.initialize();
        return this.m_pinger.ping(host, timeout, retries);
    }

    public Number ping(InetAddress host) throws Exception {
        this.initialize();
        return this.m_pinger.ping(host);
    }

    public List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval) throws Exception {
        this.initialize();
        return this.m_pinger.parallelPing(host, count, timeout, pingInterval);
    }

    public List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval, int size) throws Exception {
        this.initialize();
        return this.m_pinger.parallelPing(host, count, timeout, pingInterval, size);
    }

    public void initialize4() throws Exception {
        this.initialize();
    }

    public void initialize6() throws Exception {
        this.initialize();
    }

    public boolean isV4Available() {
        this.initialize();
        return this.m_pinger.isV4Available();
    }

    public boolean isV6Available() {
        this.initialize();
        return this.m_pinger.isV6Available();
    }

    public void setAllowFragmentation(boolean allow) throws Exception {
        if (this.m_pinger != null) {
            this.m_pinger.setAllowFragmentation(allow);
        }
        this.m_allowFragmentation = allow;
    }

    public void setTrafficClass(int tc) throws Exception {
        if (this.m_pinger != null) {
            this.m_pinger.setTrafficClass(tc);
        }
        this.m_trafficClass = tc;
    }

    private void initialize() {
        if (this.m_pinger == null) {
            Class<? extends Pinger> pinger = BestMatchPingerFactory.findPinger();
            try {
                this.m_pinger = pinger.newInstance();
            }
            catch (Throwable t) {
                LOG.error("Failed to initialize best match pinger ({}).  Falling back to the null pinger.", pinger, (Object)t);
                this.m_pinger = new NullPinger();
            }
            try {
                if (this.m_allowFragmentation != null) {
                    this.m_pinger.setAllowFragmentation(this.m_allowFragmentation.booleanValue());
                }
            }
            catch (Throwable t) {
                LOG.debug("Failed to set 'allow fragmentation' flag on pinger {}", pinger, (Object)t);
            }
            try {
                if (this.m_trafficClass != null) {
                    this.m_pinger.setTrafficClass(this.m_trafficClass.intValue());
                }
            }
            catch (Throwable t) {
                LOG.debug("Failed to set traffic class on pinger {}", pinger, (Object)t);
            }
        }
    }
}

