/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.collection.adapters.GenericTypeResourceAdapter;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.PersistenceSelectorStrategy;
import org.opennms.netmgt.collection.api.ResourceType;
import org.opennms.netmgt.collection.api.StorageStrategy;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.model.ResourcePath;
import org.springframework.orm.ObjectRetrievalFailureException;

@XmlJavaTypeAdapter(value=GenericTypeResourceAdapter.class)
public class GenericTypeResource
extends DeferredGenericTypeResource {
    private final ResourceType m_resourceType;
    private final StorageStrategy m_storageStrategy;
    private final PersistenceSelectorStrategy m_persistenceSelectorStrategy;

    public GenericTypeResource(NodeLevelResource node, ResourceType resourceType, String instance) {
        super(node, Objects.requireNonNull(resourceType, "resourceType argument").getName(), instance);
        this.m_resourceType = Objects.requireNonNull(resourceType, "resourceType argument");
        this.m_storageStrategy = this.instantiateStorageStrategy(resourceType.getStorageStrategy().getClazz(), resourceType.getName());
        this.m_storageStrategy.setParameters(resourceType.getStorageStrategy().getParameters());
        this.m_persistenceSelectorStrategy = this.instantiatePersistenceSelector(resourceType.getPersistenceSelectorStrategy().getClazz());
        this.m_persistenceSelectorStrategy.setParameters(resourceType.getPersistenceSelectorStrategy().getParameters());
    }

    protected static String sanitizeInstance(String instance) {
        return instance.replaceAll("\\s+", "_").replaceAll(":", "_").replaceAll("\\\\", "_").replaceAll("[\\[\\]]", "_");
    }

    public ResourceType getResourceType() {
        return this.m_resourceType;
    }

    @Override
    public ResourcePath getPath(CollectionResource resource) {
        return this.getStorageStrategy().getRelativePathForAttribute(ResourcePath.get((String[])new String[0]), this.getStorageStrategy().getResourceNameFromIndex(resource));
    }

    @Override
    public Resource resolve() {
        return this;
    }

    public StorageStrategy getStorageStrategy() {
        return this.m_storageStrategy;
    }

    public PersistenceSelectorStrategy getPersistenceSelectorStrategy() {
        return this.m_persistenceSelectorStrategy;
    }

    private StorageStrategy instantiateStorageStrategy(String className, String resourceTypeName) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            StorageStrategy storageStrategy = (StorageStrategy)cinst.newInstance();
            storageStrategy.setResourceTypeName(resourceTypeName);
            return storageStrategy;
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
    }

    private PersistenceSelectorStrategy instantiatePersistenceSelector(String className) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            return (PersistenceSelectorStrategy)cinst.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
    }

    @Override
    public String getTypeName() {
        return this.m_resourceType.getName();
    }

    @Override
    public String toString() {
        return String.format("GenericTypeResource[node=%s, instance=%s, resourceType=%s,storageStrategy=%s, persistenceSelectorStrategy=%s]", this.getParent(), this.getInstance(), this.m_resourceType, this.m_storageStrategy, this.m_persistenceSelectorStrategy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getParent(), this.getInstance(), this.m_resourceType, this.getTimestamp());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericTypeResource)) {
            return false;
        }
        GenericTypeResource other = (GenericTypeResource)obj;
        return super.equals(other) && Objects.equals(this.m_resourceType, other.m_resourceType);
    }
}

