/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.common;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.AsyncPolicy;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SyncDispatcher;
import org.opennms.core.ipc.sink.common.DispatcherState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDispatcherImpl<W, S extends Message, T extends Message>
implements AsyncDispatcher<S> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDispatcherImpl.class);
    private final SyncDispatcher<S> syncDispatcher;
    final RateLimitedLog rateLimittedLogger = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.standardSeconds((long)30L)).build();
    final LinkedBlockingQueue<Runnable> queue;
    final ExecutorService executor;

    public AsyncDispatcherImpl(DispatcherState<W, S, T> state, AsyncPolicy asyncPolicy, SyncDispatcher<S> syncDispatcher) {
        RejectedExecutionHandler rejectedExecutionHandler;
        Objects.requireNonNull(state);
        Objects.requireNonNull(asyncPolicy);
        this.syncDispatcher = Objects.requireNonNull(syncDispatcher);
        if (asyncPolicy.isBlockWhenFull()) {
            this.queue = new OfferBlockingQueue<Runnable>(asyncPolicy.getQueueSize());
            rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
        } else {
            this.queue = new LinkedBlockingQueue(asyncPolicy.getQueueSize());
            final Counter droppedCounter = state.getMetrics().counter(MetricRegistry.name((String)state.getModule().getId(), (String[])new String[]{"dropped"}));
            rejectedExecutionHandler = new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                    droppedCounter.inc();
                    throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString());
                }
            };
        }
        state.getMetrics().register(MetricRegistry.name((String)state.getModule().getId(), (String[])new String[]{"queue-size"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return AsyncDispatcherImpl.this.queue.size();
            }
        });
        this.executor = new ThreadPoolExecutor(asyncPolicy.getNumThreads(), asyncPolicy.getNumThreads(), 1000L, TimeUnit.MILLISECONDS, this.queue, (ThreadFactory)new LogPreservingThreadFactory("OpenNMS.Sink.AsyncDispatcher." + state.getModule().getId(), Integer.MAX_VALUE), rejectedExecutionHandler);
    }

    public CompletableFuture<S> send(S message) {
        try {
            return CompletableFuture.supplyAsync(() -> {
                this.syncDispatcher.send(message);
                return message;
            }, this.executor);
        }
        catch (RejectedExecutionException ree) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(ree);
            return future;
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public void close() throws Exception {
        this.syncDispatcher.close();
        this.executor.shutdown();
    }

    private static class OfferBlockingQueue<E>
    extends LinkedBlockingQueue<E> {
        private static final long serialVersionUID = 1L;

        public OfferBlockingQueue(int capacity) {
            super(capacity);
        }

        @Override
        public boolean offer(E e) {
            try {
                this.put(e);
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }
}

