/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.aggregation;

import com.google.common.util.concurrent.Striped;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.opennms.core.ipc.sink.aggregation.AggregatingMessageProducer;
import org.opennms.core.ipc.sink.api.AggregationPolicy;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregator<S extends Message, T extends Message>
implements AutoCloseable,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Aggregator.class);
    public static final String NUM_STRIPE_LOCKS_SYS_PROP = "org.opennms.ipc.sink.aggregation.stripes";
    public static final int DEFAULT_NUM_STRIPE_LOCKS = 64;
    private static final int NUM_STRIPE_LOCKS = Integer.getInteger("org.opennms.ipc.sink.aggregation.stripes", 64);
    private final AggregationPolicy<S, T> aggregationPolicy;
    private final AggregatingMessageProducer<S, T> messageProducer;
    private final int completionSize;
    private final long completionIntervalMs;
    private final Timer flushTimer;
    private final ConcurrentHashMap<Object, Bucket> buckets = new ConcurrentHashMap();
    private final Striped<Lock> lockStripes = Striped.lock((int)NUM_STRIPE_LOCKS);

    public Aggregator(final SinkModule<S, T> module, AggregatingMessageProducer<S, T> messageProducer) {
        Objects.requireNonNull(module);
        this.messageProducer = Objects.requireNonNull(messageProducer);
        this.aggregationPolicy = Objects.requireNonNull(module.getAggregationPolicy());
        this.completionSize = this.aggregationPolicy.getCompletionSize();
        this.completionIntervalMs = this.aggregationPolicy.getCompletionIntervalMs();
        if (this.completionIntervalMs > 0L) {
            this.flushTimer = new Timer(String.format("SinkAggregatorFlush-%s", module.getId()));
            this.flushTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        Aggregator.this.run();
                    }
                    catch (Throwable t) {
                        LOG.error("An error occurred while flushing one or more aggregates in module '{}'.", (Object)module, (Object)t);
                    }
                }
            }, this.completionIntervalMs, this.completionIntervalMs);
        } else {
            this.flushTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T aggregate(S message) {
        Object key = this.aggregationPolicy.key(message);
        Lock lock = (Lock)this.lockStripes.get(key);
        try {
            Object accumulator;
            lock.lock();
            Bucket bucket = this.buckets.get(key);
            if (bucket == null) {
                bucket = new Bucket();
                this.buckets.put(key, bucket);
            }
            if ((accumulator = bucket.accumulate(message)) != null) {
                this.buckets.remove(key);
                Object t = accumulator;
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LinkedList messagesReadyForDispatch = new LinkedList();
        Set keys = this.buckets.keySet();
        Iterable locks = this.lockStripes.bulkGet((Iterable)keys);
        try {
            locks.forEach(l -> l.lock());
            long cutOff = System.currentTimeMillis() - this.completionIntervalMs;
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Bucket bucket = this.buckets.get(key);
                if (bucket == null || bucket.getFirstTimeMillis() == null || bucket.getFirstTimeMillis() > cutOff) continue;
                messagesReadyForDispatch.add(bucket.getValue());
                iter.remove();
            }
        }
        finally {
            locks.forEach(l -> l.unlock());
        }
        for (Message message : messagesReadyForDispatch) {
            this.messageProducer.dispatch(message);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.flushTimer != null) {
            this.flushTimer.cancel();
        }
    }

    protected class Bucket {
        private T accumulator;
        private int count = 0;
        private Long firstTimeMillis;

        protected Bucket() {
        }

        public T accumulate(S message) {
            this.accumulator = Aggregator.this.aggregationPolicy.aggregate(this.accumulator, message);
            ++this.count;
            if (this.count >= Aggregator.this.completionSize) {
                return this.accumulator;
            }
            if (Aggregator.this.completionIntervalMs > 0L) {
                long now = System.currentTimeMillis();
                if (this.firstTimeMillis == null) {
                    this.firstTimeMillis = now;
                } else if (now - this.firstTimeMillis >= Aggregator.this.completionIntervalMs) {
                    return this.accumulator;
                }
            }
            return null;
        }

        public T getValue() {
            return this.accumulator;
        }

        public Long getFirstTimeMillis() {
            return this.firstTimeMillis;
        }
    }
}

