/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.aggregation;

import org.opennms.core.ipc.sink.aggregation.Aggregator;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.api.SyncDispatcher;

public abstract class AggregatingMessageProducer<S extends Message, T extends Message>
implements SyncDispatcher<S> {
    private final Aggregator<S, T> aggregator;

    public AggregatingMessageProducer(SinkModule<S, T> module) {
        this.aggregator = new Aggregator<S, T>(module, this);
    }

    public void send(S message) {
        T bucket = this.aggregator.aggregate(message);
        if (bucket != null) {
            this.dispatch(bucket);
        }
    }

    public abstract void dispatch(T var1);

    public void close() throws Exception {
        this.aggregator.close();
    }
}

