/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelRpcServerProcessor
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcServerProcessor.class);
    private final RpcModule<RpcRequest, RpcResponse> module;

    public CamelRpcServerProcessor(RpcModule<RpcRequest, RpcResponse> module) {
        this.module = Objects.requireNonNull(module);
    }

    public void process(Exchange exchange) {
        throw new UnsupportedOperationException("This processor must be invoked using the async interface.");
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        RpcRequest request = this.module.unmarshalRequest((String)exchange.getIn().getBody(String.class));
        CompletableFuture future = this.module.execute(request);
        future.whenComplete((res, ex) -> {
            try {
                RpcResponse response = ex != null ? this.module.createResponseWithException(ex) : res;
                try {
                    exchange.getOut().setBody((Object)this.module.marshalResponse(response), String.class);
                }
                catch (Throwable t) {
                    LOG.error("Marshalling a response in RPC module {} failed.", this.module, (Object)t);
                    exchange.setException(t);
                    exchange.getOut().setFault(true);
                }
            }
            finally {
                callback.done(false);
            }
        });
        return false;
    }
}

