/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.Objects;
import org.opennms.core.ipc.sink.api.AggregationPolicy;
import org.opennms.core.ipc.sink.api.AsyncPolicy;
import org.opennms.core.ipc.sink.xml.AbstractXmlSinkModule;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.snmp.TrapInformation;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JTrapNotifier;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JUtils;
import org.opennms.netmgt.trapd.TrapDTO;
import org.opennms.netmgt.trapd.TrapInformationWrapper;
import org.opennms.netmgt.trapd.TrapLogDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;

public class TrapSinkModule
extends AbstractXmlSinkModule<TrapInformationWrapper, TrapLogDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(TrapSinkModule.class);
    private final TrapdConfig config;
    private OnmsDistPoller distPoller;

    public TrapSinkModule(TrapdConfig trapdConfig, OnmsDistPoller distPoller) {
        super(TrapLogDTO.class);
        this.config = Objects.requireNonNull(trapdConfig);
        this.distPoller = Objects.requireNonNull(distPoller);
    }

    public String getId() {
        return "Trap";
    }

    public int getNumConsumerThreads() {
        return this.config.getNumThreads();
    }

    public AggregationPolicy<TrapInformationWrapper, TrapLogDTO> getAggregationPolicy() {
        return new AggregationPolicy<TrapInformationWrapper, TrapLogDTO>(){

            public int getCompletionSize() {
                return TrapSinkModule.this.config.getBatchSize();
            }

            public int getCompletionIntervalMs() {
                return TrapSinkModule.this.config.getBatchIntervalMs();
            }

            public Object key(TrapInformationWrapper message) {
                return message.getTrapInformation().getTrapAddress();
            }

            public TrapLogDTO aggregate(TrapLogDTO oldBucket, TrapInformationWrapper newMessage) {
                byte[] rawMessage;
                TrapInformation trapInfo = newMessage.getTrapInformation();
                if (oldBucket == null) {
                    oldBucket = new TrapLogDTO(TrapSinkModule.this.distPoller.getId(), TrapSinkModule.this.distPoller.getLocation(), trapInfo.getTrapAddress());
                }
                TrapDTO trapDTO = new TrapDTO(trapInfo);
                if (TrapSinkModule.this.config.isIncludeRawMessage() && (rawMessage = TrapSinkModule.convertToRawMessage(trapInfo)) != null) {
                    trapDTO.setRawMessage(TrapSinkModule.convertToRawMessage(trapInfo));
                }
                oldBucket.addMessage(trapDTO);
                return oldBucket;
            }
        };
    }

    public AsyncPolicy getAsyncPolicy() {
        return new AsyncPolicy(){

            public int getQueueSize() {
                return TrapSinkModule.this.config.getQueueSize();
            }

            public int getNumThreads() {
                return TrapSinkModule.this.config.getNumThreads();
            }

            public boolean isBlockWhenFull() {
                return true;
            }
        };
    }

    private static byte[] convertToRawMessage(TrapInformation trapInfo) {
        if (!(trapInfo instanceof Snmp4JTrapNotifier.Snmp4JV1TrapInformation) && !(trapInfo instanceof Snmp4JTrapNotifier.Snmp4JV2TrapInformation)) {
            LOG.warn("Unable to convert TrapInformation of type {} to raw message. Please use {} as snmp strategy to include raw messages", trapInfo.getClass(), Snmp4JStrategy.class);
            return null;
        }
        try {
            PDU pdu = TrapSinkModule.extractPDU(trapInfo);
            if (pdu != null) {
                return Snmp4JUtils.convertPduToBytes((InetAddress)trapInfo.getTrapAddress(), (int)0, (String)trapInfo.getCommunity(), (PDU)pdu);
            }
        }
        catch (Throwable e) {
            LOG.warn("Unable to convert PDU into bytes: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static PDU extractPDU(TrapInformation trapInfo) {
        if (trapInfo instanceof Snmp4JTrapNotifier.Snmp4JV1TrapInformation) {
            return ((Snmp4JTrapNotifier.Snmp4JV1TrapInformation)trapInfo).getPdu();
        }
        if (trapInfo instanceof Snmp4JTrapNotifier.Snmp4JV2TrapInformation) {
            return ((Snmp4JTrapNotifier.Snmp4JV2TrapInformation)trapInfo).getPdu();
        }
        throw new IllegalArgumentException("Cannot extract PDU from trapInfo of type " + trapInfo.getClass());
    }
}

