/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.wsman.cxf;

import java.net.URI;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.opennms.core.wsman.exceptions.WSManException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlsoap.schemas.ws._2004._09.enumeration.EnumerateResponse;
import org.xmlsoap.schemas.ws._2004._09.enumeration.EnumerationContextType;
import org.xmlsoap.schemas.ws._2004._09.enumeration.PullResponse;
import org.xmlsoap.schemas.ws._2004._09.transfer.TransferElement;
import schemas.dmtf.org.wbem.wsman.v1.AnyListType;
import schemas.dmtf.org.wbem.wsman.v1.MixedDataType;

public class TypeUtils {
    private static final QName WSEN_Items_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/enumeration", "Items");
    private static final QName WSEN_EndOfSequence_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/enumeration", "EndOfSequence");
    private static final QName WSMAN_Items_QNAME = new QName("http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd", "Items");
    private static final QName WSMAN_EndOfSequence_QNAME = new QName("http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd", "EndOfSequence");
    private static final QName WSMAN_XmlFragment_QNAME = new QName("http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd", "XmlFragment");
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    protected static String getContextIdFrom(EnumerateResponse response) {
        return TypeUtils.getContextIdFrom(response.getEnumerationContext());
    }

    protected static String getContextIdFrom(PullResponse response) {
        if (response.getEnumerationContext() == null) {
            return null;
        }
        return TypeUtils.getContextIdFrom(response.getEnumerationContext());
    }

    protected static String getContextIdFrom(EnumerationContextType context) {
        if (context == null || context.getContent() == null) {
            throw new WSManException(String.format("EnumerationContext %s has no content.", context));
        }
        if (context.getContent().size() == 0) {
            return null;
        }
        if (context.getContent().size() == 1) {
            Object content = context.getContent().get(0);
            if (content instanceof String) {
                return (String)content;
            }
            throw new WSManException(String.format("Unsupported EnumerationContext content: %s", content));
        }
        throw new WSManException(String.format("EnumerationContext contains too many elements, expected: 1 actual: %d", context.getContent().size()));
    }

    protected static boolean getItemsFrom(EnumerateResponse response, List<Node> items) {
        boolean endOfSequence = false;
        for (Object object : response.getAny()) {
            if (object instanceof JAXBElement) {
                JAXBElement el = (JAXBElement)object;
                if (WSEN_Items_QNAME.equals(el.getName()) || WSMAN_Items_QNAME.equals(el.getName())) {
                    if (el.isNil()) continue;
                    if (el.getValue() instanceof AnyListType) {
                        AnyListType itemList = (AnyListType)el.getValue();
                        for (Object item : itemList.getAny()) {
                            if (item instanceof Node) {
                                Node node = (Node)item;
                                items.add(node);
                                continue;
                            }
                            if (item instanceof JAXBElement) {
                                JAXBElement nestedEl = (JAXBElement)item;
                                if (!WSMAN_XmlFragment_QNAME.equals(nestedEl.getName()) || nestedEl.isNil() || !(nestedEl.getValue() instanceof MixedDataType)) continue;
                                Document document = TypeUtils.createNewDocument();
                                Element rootElement = document.createElementNS(WSMAN_XmlFragment_QNAME.getNamespaceURI(), WSMAN_XmlFragment_QNAME.getLocalPart());
                                document.appendChild(rootElement);
                                MixedDataType mixed = (MixedDataType)nestedEl.getValue();
                                for (Object nestedItem : mixed.getContent()) {
                                    if (nestedItem instanceof String) continue;
                                    if (nestedItem instanceof Node) {
                                        Node nestedNode = document.importNode((Node)nestedItem, true);
                                        rootElement.appendChild(nestedNode);
                                        continue;
                                    }
                                    throw new WSManException(String.format("Unsupported element of type %s in XmlFragment: %s", nestedItem.getClass(), nestedItem));
                                }
                                items.add(rootElement);
                                continue;
                            }
                            throw new WSManException(String.format("Unsupported element of type %s in EnumerateResponse: %s", object.getClass(), object));
                        }
                        continue;
                    }
                    throw new WSManException(String.format("Unsupported value in EnumerateResponse Items: %s of type: %s", el.getValue(), el.getValue().getClass()));
                }
                if (WSEN_EndOfSequence_QNAME.equals(el.getName()) || WSMAN_EndOfSequence_QNAME.equals(el.getName())) {
                    endOfSequence = true;
                    continue;
                }
                throw new WSManException(String.format("Unsupported element in EnumerateResponse: %s with name: %s", el, el.getName()));
            }
            if (object instanceof Node) {
                Node node = (Node)object;
                if (WSEN_EndOfSequence_QNAME.getNamespaceURI().equals(node.getNamespaceURI()) && WSEN_EndOfSequence_QNAME.getLocalPart().equals(node.getLocalName()) || WSMAN_EndOfSequence_QNAME.getNamespaceURI().equals(node.getNamespaceURI()) && WSMAN_EndOfSequence_QNAME.getLocalPart().equals(node.getLocalName())) {
                    endOfSequence = true;
                    continue;
                }
                throw new WSManException(String.format("Unsupported node in EnumerateResponse: %s with namespace: %s", node, node.getNamespaceURI()));
            }
            throw new WSManException(String.format("Unsupported element in EnumerateResponse: %s, with type: %s", object, object != null ? object.getClass() : null));
        }
        return endOfSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document createNewDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory documentBuilderFactory = DOCUMENT_BUILDER_FACTORY;
        synchronized (documentBuilderFactory) {
            try {
                builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.newDocument();
    }

    protected static boolean getItemsFrom(PullResponse response, List<Node> items) {
        for (Object item : response.getItems().getAny()) {
            if (item instanceof Node) {
                items.add((Node)item);
                continue;
            }
            throw new WSManException(String.format("The pull response contains an unsupported item %s of type %s", item, item != null ? item.getClass() : null));
        }
        return response.getEndOfSequence() != null;
    }

    protected static Node transferElementToNode(TransferElement el, String namespaceURI, String qualifiedName) {
        try {
            DOMResult domResult = new DOMResult();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{el.getClass()});
            context.createMarshaller().marshal((Object)el, (Result)domResult);
            Document doc = (Document)domResult.getNode();
            Node node = doc.getFirstChild();
            doc.renameNode(node, namespaceURI, qualifiedName);
            return doc.getFirstChild();
        }
        catch (JAXBException e) {
            throw new WSManException("XML serialization failed.", (Throwable)e);
        }
    }

    protected static String getElementTypeFromResourceUri(String resourceUri) {
        String elementType = null;
        try {
            URI uri = new URI(resourceUri);
            String path = uri.getPath();
            elementType = path.substring(path.lastIndexOf(47) + 1);
        }
        catch (Throwable t) {
            throw new WSManException("Failed to determine the element type from resource uri: " + resourceUri, t);
        }
        return elementType;
    }
}

