/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.snmp.proxy.WalkRequest;
import org.opennms.netmgt.snmp.proxy.WalkResponse;

public class CorrelationIdUtils {
    private static final Pattern POP_INDEX_PATTERN = Pattern.compile("^(\\d+)(-(.*))?$");

    public static void pushIndexToCorrelationId(WalkRequest walkRequest, int idx) {
        String effectiveCorrelationId = null;
        effectiveCorrelationId = walkRequest.getCorrelationId() == null ? Integer.toString(idx) : String.format("%d-%s", idx, walkRequest.getCorrelationId());
        walkRequest.setCorrelationId(effectiveCorrelationId);
    }

    public static void popIndexFromCollerationId(WalkResponse walkResponse, Map<Integer, List<WalkResponse>> responsesByIndex) {
        if (walkResponse.getCorrelationId() == null) {
            return;
        }
        Matcher m = POP_INDEX_PATTERN.matcher(walkResponse.getCorrelationId());
        if (m.matches()) {
            int index = Integer.valueOf(m.group(1));
            WalkResponse clonedResponse = new WalkResponse(walkResponse.getResults(), m.group(3));
            List<WalkResponse> responsesAtIndex = responsesByIndex.get(index);
            if (responsesAtIndex == null) {
                responsesAtIndex = new ArrayList<WalkResponse>();
                responsesByIndex.put(index, responsesAtIndex);
            }
            responsesAtIndex.add(clonedResponse);
        }
    }
}

