/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.consumer.ConsumerConfig$;
import kafka.message.Message$;
import kafka.message.MessageSet$;
import kafka.utils.Utils$;
import kafka.utils.VerifiableProperties;
import kafka.utils.ZKConfig;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001B\u0001\u0003\u0001\u001d\u00111bS1gW\u0006\u001cuN\u001c4jO*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0006kRLGn]\u0005\u0003\u001b)\u0011\u0001BW&D_:4\u0017n\u001a\u0005\t\u001f\u0001\u0011)\u0019!C\u0001!\u0005)\u0001O]8qgV\t\u0011\u0003\u0005\u0002\n%%\u00111C\u0003\u0002\u0015-\u0016\u0014\u0018NZ5bE2,\u0007K]8qKJ$\u0018.Z:\t\u0011U\u0001!\u0011!Q\u0001\nE\ta\u0001\u001d:paN\u0004\u0003\"B\f\u0001\t\u0013A\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001a7A\u0011!\u0004A\u0007\u0002\u0005!)qB\u0006a\u0001#!)q\u0003\u0001C\u0001;Q\u0011\u0011D\b\u0005\u0006?q\u0001\r\u0001I\u0001\u000e_JLw-\u001b8bYB\u0013x\u000e]:\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001B;uS2T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\tQ\u0001K]8qKJ$\u0018.Z:\t\u000b%\u0002A\u0011\u0002\u0016\u00023\u001d,G\u000fT8h%\u0016$XM\u001c;j_:$\u0016.\\3NS2d\u0017n\u001d\u000b\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t!Aj\u001c8h\u0011\u001d\u0011\u0004A1A\u0005\u0002M\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002iA\u0011A&N\u0005\u0003m5\u00121!\u00138u\u0011\u0019A\u0004\u0001)A\u0005i\u0005I!M]8lKJLE\r\t\u0005\bu\u0001\u0011\r\u0011\"\u00014\u0003=iWm]:bO\u0016l\u0015\r\u001f\"zi\u0016\u001c\bB\u0002\u001f\u0001A\u0003%A'\u0001\tnKN\u001c\u0018mZ3NCb\u0014\u0015\u0010^3tA!9a\b\u0001b\u0001\n\u0003\u0019\u0014!\u00058v[:+Go^8sWRC'/Z1eg\"1\u0001\t\u0001Q\u0001\nQ\n!C\\;n\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193tA!9!\t\u0001b\u0001\n\u0003\u0019\u0014\u0001\u00048v[&{G\u000b\u001b:fC\u0012\u001c\bB\u0002#\u0001A\u0003%A'A\u0007ok6Lu\u000e\u00165sK\u0006$7\u000f\t\u0005\b\r\u0002\u0011\r\u0011\"\u00014\u0003E\u0011\u0017mY6he>,h\u000e\u001a+ie\u0016\fGm\u001d\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\u001b\u0002%\t\f7m[4s_VtG\r\u00165sK\u0006$7\u000f\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u00014\u0003E\tX/Z;fI6\u000b\u0007PU3rk\u0016\u001cHo\u001d\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002\u001b\u0002%E,X-^3e\u001b\u0006D(+Z9vKN$8\u000f\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u00014\u0003\u0011\u0001xN\u001d;\t\rA\u0003\u0001\u0015!\u00035\u0003\u0015\u0001xN\u001d;!\u0011\u001d\u0011\u0006A1A\u0005\u0002M\u000b\u0001\u0002[8ti:\u000bW.Z\u000b\u0002)B\u0011Q\u000b\u0017\b\u0003YYK!aV\u0017\u0002\rA\u0013X\rZ3g\u0013\tI&L\u0001\u0004TiJLgn\u001a\u0006\u0003/6Ba\u0001\u0018\u0001!\u0002\u0013!\u0016!\u00035pgRt\u0015-\\3!\u0011\u001dq\u0006A1A\u0005\u0002M\u000b!#\u00193wKJ$\u0018n]3e\u0011>\u001cHOT1nK\"1\u0001\r\u0001Q\u0001\nQ\u000b1#\u00193wKJ$\u0018n]3e\u0011>\u001cHOT1nK\u0002BqA\u0019\u0001C\u0002\u0013\u00051'\u0001\bbIZ,'\u000f^5tK\u0012\u0004vN\u001d;\t\r\u0011\u0004\u0001\u0015!\u00035\u0003=\tGM^3si&\u001cX\r\u001a)peR\u0004\u0003b\u00024\u0001\u0005\u0004%\taM\u0001\u0016g>\u001c7.\u001a;TK:$')\u001e4gKJ\u0014\u0015\u0010^3t\u0011\u0019A\u0007\u0001)A\u0005i\u000512o\\2lKR\u001cVM\u001c3Ck\u001a4WM\u001d\"zi\u0016\u001c\b\u0005C\u0004k\u0001\t\u0007I\u0011A\u001a\u00021M|7m[3u%\u0016\u001cW-\u001b<f\u0005V4g-\u001a:CsR,7\u000f\u0003\u0004m\u0001\u0001\u0006I\u0001N\u0001\u001ag>\u001c7.\u001a;SK\u000e,\u0017N^3Ck\u001a4WM\u001d\"zi\u0016\u001c\b\u0005C\u0004o\u0001\t\u0007I\u0011A\u001a\u0002+M|7m[3u%\u0016\fX/Z:u\u001b\u0006D()\u001f;fg\"1\u0001\u000f\u0001Q\u0001\nQ\nac]8dW\u0016$(+Z9vKN$X*\u0019=CsR,7\u000f\t\u0005\be\u0002\u0011\r\u0011\"\u00014\u00035qW/\u001c)beRLG/[8og\"1A\u000f\u0001Q\u0001\nQ\naB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004w\u0001\t\u0007I\u0011A<\u0002\u000f1|w\rR5sgV\t\u0001\u0010E\u0002zyRk\u0011A\u001f\u0006\u0003w6\n!bY8mY\u0016\u001cG/[8o\u0013\ti(PA\u0002TKFDaa \u0001!\u0002\u0013A\u0018\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011\u0005\r\u0001A1A\u0005\u0002M\nq\u0002\\8h'\u0016<W.\u001a8u\u0005f$Xm\u001d\u0005\b\u0003\u000f\u0001\u0001\u0015!\u00035\u0003AawnZ*fO6,g\u000e\u001e\"zi\u0016\u001c\b\u0005\u0003\u0005\u0002\f\u0001\u0011\r\u0011\"\u00014\u00031awn\u001a*pY2Du.\u001e:t\u0011\u001d\ty\u0001\u0001Q\u0001\nQ\nQ\u0002\\8h%>dG\u000eS8veN\u0004\u0003\"CA\n\u0001\t\u0007I\u0011AA\u000b\u0003Yawn\u001a*fi\u0016tG/[8o)&lW-T5mY&\u001cX#A\u0016\t\u000f\u0005e\u0001\u0001)A\u0005W\u00059Bn\\4SKR,g\u000e^5p]RKW.Z'jY2L7\u000f\t\u0005\n\u0003;\u0001!\u0019!C\u0001\u0003+\t\u0011\u0003\\8h%\u0016$XM\u001c;j_:\u0014\u0015\u0010^3t\u0011\u001d\t\t\u0003\u0001Q\u0001\n-\n!\u0003\\8h%\u0016$XM\u001c;j_:\u0014\u0015\u0010^3tA!I\u0011Q\u0005\u0001C\u0002\u0013\u0005\u0011QC\u0001\u0015Y><7\t\\3b]V\u0004\u0018J\u001c;feZ\fG.T:\t\u000f\u0005%\u0002\u0001)A\u0005W\u0005)Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0003\u0002CA\u0017\u0001\t\u0007I\u0011A*\u0002!1|wm\u00117fC:,\b\u000fU8mS\u000eL\bbBA\u0019\u0001\u0001\u0006I\u0001V\u0001\u0012Y><7\t\\3b]V\u0004\bk\u001c7jGf\u0004\u0003\u0002CA\u001b\u0001\t\u0007I\u0011A\u001a\u0002#1|wm\u00117fC:,'\u000f\u00165sK\u0006$7\u000fC\u0004\u0002:\u0001\u0001\u000b\u0011\u0002\u001b\u0002%1|wm\u00117fC:,'\u000f\u00165sK\u0006$7\u000f\t\u0005\n\u0003{\u0001!\u0019!C\u0001\u0003\u007f\tQ\u0004\\8h\u00072,\u0017M\\3s\u0013>l\u0015\r\u001f\"zi\u0016\u001c\b+\u001a:TK\u000e|g\u000eZ\u000b\u0003\u0003\u0003\u00022\u0001LA\"\u0013\r\t)%\f\u0002\u0007\t>,(\r\\3\t\u0011\u0005%\u0003\u0001)A\u0005\u0003\u0003\na\u0004\\8h\u00072,\u0017M\\3s\u0013>l\u0015\r\u001f\"zi\u0016\u001c\b+\u001a:TK\u000e|g\u000e\u001a\u0011\t\u0013\u00055\u0003A1A\u0005\u0002\u0005U\u0011A\u00077pO\u000ecW-\u00198fe\u0012+G-\u001e9f\u0005V4g-\u001a:TSj,\u0007bBA)\u0001\u0001\u0006IaK\u0001\u001cY><7\t\\3b]\u0016\u0014H)\u001a3va\u0016\u0014UO\u001a4feNK'0\u001a\u0011\t\u0011\u0005U\u0003A1A\u0005\u0002M\na\u0003\\8h\u00072,\u0017M\\3s\u0013>\u0014UO\u001a4feNK'0\u001a\u0005\b\u00033\u0002\u0001\u0015!\u00035\u0003]awnZ\"mK\u0006tWM]%p\u0005V4g-\u001a:TSj,\u0007\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0001\u0002@\u0005\u0001Cn\\4DY\u0016\fg.\u001a:EK\u0012,\b/\u001a\"vM\u001a,'\u000fT8bI\u001a\u000b7\r^8s\u0011!\t\t\u0007\u0001Q\u0001\n\u0005\u0005\u0013!\t7pO\u000ecW-\u00198fe\u0012+G-\u001e9f\u0005V4g-\u001a:M_\u0006$g)Y2u_J\u0004\u0003\"CA3\u0001\t\u0007I\u0011AA\u000b\u0003MawnZ\"mK\u0006tWM\u001d\"bG.|gMZ't\u0011\u001d\tI\u0007\u0001Q\u0001\n-\nA\u0003\\8h\u00072,\u0017M\\3s\u0005\u0006\u001c7n\u001c4g\u001bN\u0004\u0003\"CA7\u0001\t\u0007I\u0011AA \u0003]awnZ\"mK\u0006tWM]'j]\u000ecW-\u00198SCRLw\u000e\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA!\u0003aawnZ\"mK\u0006tWM]'j]\u000ecW-\u00198SCRLw\u000e\t\u0005\n\u0003k\u0002!\u0019!C\u0001\u0003o\n\u0001\u0003\\8h\u00072,\u0017M\\3s\u000b:\f'\r\\3\u0016\u0005\u0005e\u0004c\u0001\u0017\u0002|%\u0019\u0011QP\u0017\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\u0011\u0001!\u0002\u0013\tI(A\tm_\u001e\u001cE.Z1oKJ,e.\u00192mK\u0002B\u0011\"!\"\u0001\u0005\u0004%\t!!\u0006\u000271|wm\u00117fC:,'\u000fR3mKR,'+\u001a;f]RLwN\\'t\u0011\u001d\tI\t\u0001Q\u0001\n-\nA\u0004\\8h\u00072,\u0017M\\3s\t\u0016dW\r^3SKR,g\u000e^5p]6\u001b\b\u0005\u0003\u0005\u0002\u000e\u0002\u0011\r\u0011\"\u00014\u0003QawnZ%oI\u0016D8+\u001b>f\u001b\u0006D()\u001f;fg\"9\u0011\u0011\u0013\u0001!\u0002\u0013!\u0014!\u00067pO&sG-\u001a=TSj,W*\u0019=CsR,7\u000f\t\u0005\t\u0003+\u0003!\u0019!C\u0001g\u0005)Bn\\4J]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\bbBAM\u0001\u0001\u0006I\u0001N\u0001\u0017Y><\u0017J\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3tA!I\u0011Q\u0014\u0001C\u0002\u0013\u0005\u0011QC\u0001\u0019Y><g\t\\;tQ&sG/\u001a:wC2lUm]:bO\u0016\u001c\bbBAQ\u0001\u0001\u0006IaK\u0001\u001aY><g\t\\;tQ&sG/\u001a:wC2lUm]:bO\u0016\u001c\b\u0005C\u0005\u0002&\u0002\u0011\r\u0011\"\u0001\u0002\u0016\u0005\u0001Bn\\4EK2,G/\u001a#fY\u0006LXj\u001d\u0005\b\u0003S\u0003\u0001\u0015!\u0003,\u0003Eawn\u001a#fY\u0016$X\rR3mCfl5\u000f\t\u0005\n\u0003[\u0003!\u0019!C\u0001\u0003+\t1\u0004\\8h\r2,8\u000f[*dQ\u0016$W\u000f\\3s\u0013:$XM\u001d<bY6\u001b\bbBAY\u0001\u0001\u0006IaK\u0001\u001dY><g\t\\;tQN\u001b\u0007.\u001a3vY\u0016\u0014\u0018J\u001c;feZ\fG.T:!\u0011%\t)\f\u0001b\u0001\n\u0003\t)\"\u0001\nm_\u001e4E.^:i\u0013:$XM\u001d<bY6\u001b\bbBA]\u0001\u0001\u0006IaK\u0001\u0014Y><g\t\\;tQ&sG/\u001a:wC2l5\u000f\t\u0005\t\u0003{\u0003!\u0019!C\u0001g\u0005\u0011Cn\\4GYV\u001c\bn\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;J]R,'O^1m\u001bNDq!!1\u0001A\u0003%A'A\u0012m_\u001e4E.^:i\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dWj\u001d\u0011\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005]\u0014AF1vi>\u001c%/Z1uKR{\u0007/[2t\u000b:\f'\r\\3\t\u0011\u0005%\u0007\u0001)A\u0005\u0003s\nq#Y;u_\u000e\u0013X-\u0019;f)>\u0004\u0018nY:F]\u0006\u0014G.\u001a\u0011\t\u0011\u00055\u0007A1A\u0005\u0002M\n\u0011dY8oiJ|G\u000e\\3s'>\u001c7.\u001a;US6,w.\u001e;Ng\"9\u0011\u0011\u001b\u0001!\u0002\u0013!\u0014AG2p]R\u0014x\u000e\u001c7feN{7m[3u)&lWm\\;u\u001bN\u0004\u0003\u0002CAk\u0001\t\u0007I\u0011A\u001a\u00025\r|g\u000e\u001e:pY2,'/T3tg\u0006<W-U;fk\u0016\u001c\u0016N_3\t\u000f\u0005e\u0007\u0001)A\u0005i\u0005Y2m\u001c8ue>dG.\u001a:NKN\u001c\u0018mZ3Rk\u0016,XmU5{K\u0002B\u0001\"!8\u0001\u0005\u0004%\taM\u0001\u0019I\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014\bbBAq\u0001\u0001\u0006I\u0001N\u0001\u001aI\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014\b\u0005C\u0005\u0002f\u0002\u0011\r\u0011\"\u0001\u0002\u0016\u0005\u0019\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\"9\u0011\u0011\u001e\u0001!\u0002\u0013Y\u0013\u0001\u0006:fa2L7-\u0019'bORKW.Z'bq6\u001b\b\u0005C\u0005\u0002n\u0002\u0011\r\u0011\"\u0001\u0002\u0016\u0005)\"/\u001a9mS\u000e\fG*Y4NCblUm]:bO\u0016\u001c\bbBAy\u0001\u0001\u0006IaK\u0001\u0017e\u0016\u0004H.[2b\u0019\u0006<W*\u0019=NKN\u001c\u0018mZ3tA!A\u0011Q\u001f\u0001C\u0002\u0013\u00051'\u0001\fsKBd\u0017nY1T_\u000e\\W\r\u001e+j[\u0016|W\u000f^'t\u0011\u001d\tI\u0010\u0001Q\u0001\nQ\nqC]3qY&\u001c\u0017mU8dW\u0016$H+[7f_V$Xj\u001d\u0011\t\u0011\u0005u\bA1A\u0005\u0002M\nqD]3qY&\u001c\u0017mU8dW\u0016$(+Z2fSZ,')\u001e4gKJ\u0014\u0015\u0010^3t\u0011\u001d\u0011\t\u0001\u0001Q\u0001\nQ\n\u0001E]3qY&\u001c\u0017mU8dW\u0016$(+Z2fSZ,')\u001e4gKJ\u0014\u0015\u0010^3tA!A!Q\u0001\u0001C\u0002\u0013\u00051'\u0001\u000bsKBd\u0017nY1GKR\u001c\u0007.T1y\u0005f$Xm\u001d\u0005\b\u0005\u0013\u0001\u0001\u0015!\u00035\u0003U\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D()\u001f;fg\u0002B\u0001B!\u0004\u0001\u0005\u0004%\taM\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t\u0011\u001d\u0011\t\u0002\u0001Q\u0001\nQ\naC]3qY&\u001c\u0017MR3uG\"<\u0016-\u001b;NCbl5\u000f\t\u0005\t\u0005+\u0001!\u0019!C\u0001g\u0005!\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKNDqA!\u0007\u0001A\u0003%A'A\u000bsKBd\u0017nY1GKR\u001c\u0007.T5o\u0005f$Xm\u001d\u0011\t\u0011\tu\u0001A1A\u0005\u0002M\n!C\\;n%\u0016\u0004H.[2b\r\u0016$8\r[3sg\"9!\u0011\u0005\u0001!\u0002\u0013!\u0014a\u00058v[J+\u0007\u000f\\5dC\u001a+Go\u00195feN\u0004\u0003\"\u0003B\u0013\u0001\t\u0007I\u0011AA\u000b\u0003!\u0012X\r\u001d7jG\u0006D\u0015n\u001a5XCR,'/\\1sW\u000eCWmY6q_&tG/\u00138uKJ4\u0018\r\\'t\u0011\u001d\u0011I\u0003\u0001Q\u0001\n-\n\u0011F]3qY&\u001c\u0017\rS5hQ^\u000bG/\u001a:nCJ\\7\t[3dWB|\u0017N\u001c;J]R,'O^1m\u001bN\u0004\u0003\u0002\u0003B\u0017\u0001\t\u0007I\u0011A\u001a\u0002G\u0019,Go\u00195QkJ<\u0017\r^8ssB+(oZ3J]R,'O^1m%\u0016\fX/Z:ug\"9!\u0011\u0007\u0001!\u0002\u0013!\u0014\u0001\n4fi\u000eD\u0007+\u001e:hCR|'/\u001f)ve\u001e,\u0017J\u001c;feZ\fGNU3rk\u0016\u001cHo\u001d\u0011\t\u0011\tU\u0002A1A\u0005\u0002M\na\u0005\u001d:pIV\u001cWM\u001d)ve\u001e\fGo\u001c:z!V\u0014x-Z%oi\u0016\u0014h/\u00197SKF,Xm\u001d;t\u0011\u001d\u0011I\u0004\u0001Q\u0001\nQ\nq\u0005\u001d:pIV\u001cWM\u001d)ve\u001e\fGo\u001c:z!V\u0014x-Z%oi\u0016\u0014h/\u00197SKF,Xm\u001d;tA!I!Q\b\u0001C\u0002\u0013\u0005\u0011qO\u0001\u001aCV$x\u000eT3bI\u0016\u0014(+\u001a2bY\u0006t7-Z#oC\ndW\r\u0003\u0005\u0003B\u0001\u0001\u000b\u0011BA=\u0003i\tW\u000f^8MK\u0006$WM\u001d*fE\u0006d\u0017M\\2f\u000b:\f'\r\\3!\u0011!\u0011)\u0005\u0001b\u0001\n\u0003\u0019\u0014A\t7fC\u0012,'/S7cC2\fgnY3QKJ\u0014%o\\6feB+'oY3oi\u0006<W\rC\u0004\u0003J\u0001\u0001\u000b\u0011\u0002\u001b\u0002G1,\u0017\rZ3s\u00136\u0014\u0017\r\\1oG\u0016\u0004VM\u001d\"s_.,'\u000fU3sG\u0016tG/Y4fA!A!Q\n\u0001C\u0002\u0013\u00051'A\u0012mK\u0006$WM]%nE\u0006d\u0017M\\2f\u0007\",7m[%oi\u0016\u0014h/\u00197TK\u000e|g\u000eZ:\t\u000f\tE\u0003\u0001)A\u0005i\u0005!C.Z1eKJLUNY1mC:\u001cWm\u00115fG.Le\u000e^3sm\u0006d7+Z2p]\u0012\u001c\b\u0005\u0003\u0005\u0003V\u0001\u0011\r\u0011\"\u00014\u0003q\u0019wN\u001c;s_2dW\rZ*ikR$wn\u001e8NCb\u0014V\r\u001e:jKNDqA!\u0017\u0001A\u0003%A'A\u000fd_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^tW*\u0019=SKR\u0014\u0018.Z:!\u0011!\u0011i\u0006\u0001b\u0001\n\u0003\u0019\u0014\u0001I2p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0014V\r\u001e:z\u0005\u0006\u001c7n\u001c4g\u001bNDqA!\u0019\u0001A\u0003%A'A\u0011d_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t'+\u001a;ss\n\u000b7m[8gM6\u001b\b\u0005C\u0005\u0003f\u0001\u0011\r\u0011\"\u0001\u0002x\u0005A2m\u001c8ue>dG.\u001a3TQV$Hm\\<o\u000b:\f'\r\\3\t\u0011\t%\u0004\u0001)A\u0005\u0003s\n\u0011dY8oiJ|G\u000e\\3e'\",H\u000fZ8x]\u0016s\u0017M\u00197fA!A!Q\u000e\u0001C\u0002\u0013\u00051'A\u000bpM\u001a\u001cX\r^'fi\u0006$\u0017\r^1NCb\u001c\u0016N_3\t\u000f\tE\u0004\u0001)A\u0005i\u00051rN\u001a4tKRlU\r^1eCR\fW*\u0019=TSj,\u0007\u0005")
public class KafkaConfig
extends ZKConfig {
    private final VerifiableProperties props;
    private final int brokerId;
    private final int messageMaxBytes;
    private final int numNetworkThreads;
    private final int numIoThreads;
    private final int backgroundThreads;
    private final int queuedMaxRequests;
    private final int port;
    private final String hostName;
    private final String advertisedHostName;
    private final int advertisedPort;
    private final int socketSendBufferBytes;
    private final int socketReceiveBufferBytes;
    private final int socketRequestMaxBytes;
    private final int numPartitions;
    private final Seq<String> logDirs;
    private final int logSegmentBytes;
    private final int logRollHours;
    private final long logRetentionTimeMillis;
    private final long logRetentionBytes;
    private final long logCleanupIntervalMs;
    private final String logCleanupPolicy;
    private final int logCleanerThreads;
    private final double logCleanerIoMaxBytesPerSecond;
    private final long logCleanerDedupeBufferSize;
    private final int logCleanerIoBufferSize;
    private final double logCleanerDedupeBufferLoadFactor;
    private final long logCleanerBackoffMs;
    private final double logCleanerMinCleanRatio;
    private final boolean logCleanerEnable;
    private final long logCleanerDeleteRetentionMs;
    private final int logIndexSizeMaxBytes;
    private final int logIndexIntervalBytes;
    private final long logFlushIntervalMessages;
    private final long logDeleteDelayMs;
    private final long logFlushSchedulerIntervalMs;
    private final long logFlushIntervalMs;
    private final int logFlushOffsetCheckpointIntervalMs;
    private final boolean autoCreateTopicsEnable;
    private final int controllerSocketTimeoutMs;
    private final int controllerMessageQueueSize;
    private final int defaultReplicationFactor;
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaSocketTimeoutMs;
    private final int replicaSocketReceiveBufferBytes;
    private final int replicaFetchMaxBytes;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final int numReplicaFetchers;
    private final long replicaHighWatermarkCheckpointIntervalMs;
    private final int fetchPurgatoryPurgeIntervalRequests;
    private final int producerPurgatoryPurgeIntervalRequests;
    private final boolean autoLeaderRebalanceEnable;
    private final int leaderImbalancePerBrokerPercentage;
    private final int leaderImbalanceCheckIntervalSeconds;
    private final int controlledShutdownMaxRetries;
    private final int controlledShutdownRetryBackoffMs;
    private final boolean controlledShutdownEnable;
    private final int offsetMetadataMaxSize;

    public VerifiableProperties props() {
        return this.props;
    }

    private long getLogRetentionTimeMillis() {
        long millisInMinute = 60000L;
        long millisInHour = 60L * millisInMinute;
        return this.props().containsKey("log.retention.minutes") ? millisInMinute * (long)this.props().getIntInRange("log.retention.minutes", (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE)) : millisInHour * (long)this.props().getIntInRange("log.retention.hours", 168, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public int numNetworkThreads() {
        return this.numNetworkThreads;
    }

    public int numIoThreads() {
        return this.numIoThreads;
    }

    public int backgroundThreads() {
        return this.backgroundThreads;
    }

    public int queuedMaxRequests() {
        return this.queuedMaxRequests;
    }

    public int port() {
        return this.port;
    }

    public String hostName() {
        return this.hostName;
    }

    public String advertisedHostName() {
        return this.advertisedHostName;
    }

    public int advertisedPort() {
        return this.advertisedPort;
    }

    public int socketSendBufferBytes() {
        return this.socketSendBufferBytes;
    }

    public int socketReceiveBufferBytes() {
        return this.socketReceiveBufferBytes;
    }

    public int socketRequestMaxBytes() {
        return this.socketRequestMaxBytes;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Seq<String> logDirs() {
        return this.logDirs;
    }

    public int logSegmentBytes() {
        return this.logSegmentBytes;
    }

    public int logRollHours() {
        return this.logRollHours;
    }

    public long logRetentionTimeMillis() {
        return this.logRetentionTimeMillis;
    }

    public long logRetentionBytes() {
        return this.logRetentionBytes;
    }

    public long logCleanupIntervalMs() {
        return this.logCleanupIntervalMs;
    }

    public String logCleanupPolicy() {
        return this.logCleanupPolicy;
    }

    public int logCleanerThreads() {
        return this.logCleanerThreads;
    }

    public double logCleanerIoMaxBytesPerSecond() {
        return this.logCleanerIoMaxBytesPerSecond;
    }

    public long logCleanerDedupeBufferSize() {
        return this.logCleanerDedupeBufferSize;
    }

    public int logCleanerIoBufferSize() {
        return this.logCleanerIoBufferSize;
    }

    public double logCleanerDedupeBufferLoadFactor() {
        return this.logCleanerDedupeBufferLoadFactor;
    }

    public long logCleanerBackoffMs() {
        return this.logCleanerBackoffMs;
    }

    public double logCleanerMinCleanRatio() {
        return this.logCleanerMinCleanRatio;
    }

    public boolean logCleanerEnable() {
        return this.logCleanerEnable;
    }

    public long logCleanerDeleteRetentionMs() {
        return this.logCleanerDeleteRetentionMs;
    }

    public int logIndexSizeMaxBytes() {
        return this.logIndexSizeMaxBytes;
    }

    public int logIndexIntervalBytes() {
        return this.logIndexIntervalBytes;
    }

    public long logFlushIntervalMessages() {
        return this.logFlushIntervalMessages;
    }

    public long logDeleteDelayMs() {
        return this.logDeleteDelayMs;
    }

    public long logFlushSchedulerIntervalMs() {
        return this.logFlushSchedulerIntervalMs;
    }

    public long logFlushIntervalMs() {
        return this.logFlushIntervalMs;
    }

    public int logFlushOffsetCheckpointIntervalMs() {
        return this.logFlushOffsetCheckpointIntervalMs;
    }

    public boolean autoCreateTopicsEnable() {
        return this.autoCreateTopicsEnable;
    }

    public int controllerSocketTimeoutMs() {
        return this.controllerSocketTimeoutMs;
    }

    public int controllerMessageQueueSize() {
        return this.controllerMessageQueueSize;
    }

    public int defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaSocketTimeoutMs() {
        return this.replicaSocketTimeoutMs;
    }

    public int replicaSocketReceiveBufferBytes() {
        return this.replicaSocketReceiveBufferBytes;
    }

    public int replicaFetchMaxBytes() {
        return this.replicaFetchMaxBytes;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public long replicaHighWatermarkCheckpointIntervalMs() {
        return this.replicaHighWatermarkCheckpointIntervalMs;
    }

    public int fetchPurgatoryPurgeIntervalRequests() {
        return this.fetchPurgatoryPurgeIntervalRequests;
    }

    public int producerPurgatoryPurgeIntervalRequests() {
        return this.producerPurgatoryPurgeIntervalRequests;
    }

    public boolean autoLeaderRebalanceEnable() {
        return this.autoLeaderRebalanceEnable;
    }

    public int leaderImbalancePerBrokerPercentage() {
        return this.leaderImbalancePerBrokerPercentage;
    }

    public int leaderImbalanceCheckIntervalSeconds() {
        return this.leaderImbalanceCheckIntervalSeconds;
    }

    public int controlledShutdownMaxRetries() {
        return this.controlledShutdownMaxRetries;
    }

    public int controlledShutdownRetryBackoffMs() {
        return this.controlledShutdownRetryBackoffMs;
    }

    public boolean controlledShutdownEnable() {
        return this.controlledShutdownEnable;
    }

    public int offsetMetadataMaxSize() {
        return this.offsetMetadataMaxSize;
    }

    private KafkaConfig(VerifiableProperties props) {
        this.props = props;
        super(props);
        this.brokerId = props.getIntInRange("broker.id", (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.messageMaxBytes = props.getIntInRange("message.max.bytes", 1000000 + MessageSet$.MODULE$.LogOverhead(), (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.numNetworkThreads = props.getIntInRange("num.network.threads", 3, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.numIoThreads = props.getIntInRange("num.io.threads", 8, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.backgroundThreads = props.getIntInRange("background.threads", 4, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.queuedMaxRequests = props.getIntInRange("queued.max.requests", 500, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.port = props.getInt("port", 6667);
        this.hostName = props.getString("host.name", null);
        this.advertisedHostName = props.getString("advertised.host.name", this.hostName());
        this.advertisedPort = props.getInt("advertised.port", this.port());
        this.socketSendBufferBytes = props.getInt("socket.send.buffer.bytes", 102400);
        this.socketReceiveBufferBytes = props.getInt("socket.receive.buffer.bytes", 102400);
        this.socketRequestMaxBytes = props.getIntInRange("socket.request.max.bytes", 0x6400000, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.numPartitions = props.getIntInRange("num.partitions", 1, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logDirs = Utils$.MODULE$.parseCsvList(props.getString("log.dirs", props.getString("log.dir", "/tmp/kafka-logs")));
        Predef$.MODULE$.require(this.logDirs().size() > 0);
        this.logSegmentBytes = props.getIntInRange("log.segment.bytes", 0x40000000, (Tuple2<Object, Object>)new Tuple2.mcII.sp(Message$.MODULE$.MinHeaderSize(), Integer.MAX_VALUE));
        this.logRollHours = props.getIntInRange("log.roll.hours", 168, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logRetentionTimeMillis = this.getLogRetentionTimeMillis();
        this.logRetentionBytes = props.getLong("log.retention.bytes", -1L);
        this.logCleanupIntervalMs = props.getLongInRange("log.retention.check.interval.ms", 300000L, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(1L, Long.MAX_VALUE));
        this.logCleanupPolicy = props.getString("log.cleanup.policy", "delete");
        this.logCleanerThreads = props.getIntInRange("log.cleaner.threads", 1, (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.logCleanerIoMaxBytesPerSecond = props.getDouble("log.cleaner.io.max.bytes.per.second", Double.MAX_VALUE);
        this.logCleanerDedupeBufferSize = props.getLongInRange("log.cleaner.dedupe.buffer.size", 524288000L, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(0L, Long.MAX_VALUE));
        Predef$.MODULE$.require(this.logCleanerDedupeBufferSize() / (long)this.logCleanerThreads() > 0x100000L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "log.cleaner.dedupe.buffer.size must be at least 1MB per cleaner thread.";
            }
        });
        this.logCleanerIoBufferSize = props.getIntInRange("log.cleaner.io.buffer.size", 524288, (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.logCleanerDedupeBufferLoadFactor = props.getDouble("log.cleaner.io.buffer.load.factor", 0.9);
        this.logCleanerBackoffMs = props.getLongInRange("log.cleaner.backoff.ms", 15000L, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(0L, Long.MAX_VALUE));
        this.logCleanerMinCleanRatio = props.getDouble("log.cleaner.min.cleanable.ratio", 0.5);
        this.logCleanerEnable = props.getBoolean("log.cleaner.enable", false);
        this.logCleanerDeleteRetentionMs = props.getLong("log.cleaner.delete.retention.ms", 86400000L);
        this.logIndexSizeMaxBytes = props.getIntInRange("log.index.size.max.bytes", 0xA00000, (Tuple2<Object, Object>)new Tuple2.mcII.sp(4, Integer.MAX_VALUE));
        this.logIndexIntervalBytes = props.getIntInRange("log.index.interval.bytes", 4096, (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.logFlushIntervalMessages = props.getLongInRange("log.flush.interval.messages", Long.MAX_VALUE, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(1L, Long.MAX_VALUE));
        this.logDeleteDelayMs = props.getLongInRange("log.segment.delete.delay.ms", 60000L, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(0L, Long.MAX_VALUE));
        this.logFlushSchedulerIntervalMs = props.getLong("log.flush.scheduler.interval.ms", Long.MAX_VALUE);
        this.logFlushIntervalMs = props.getLong("log.flush.interval.ms", this.logFlushSchedulerIntervalMs());
        this.logFlushOffsetCheckpointIntervalMs = props.getIntInRange("log.flush.offset.checkpoint.interval.ms", 60000, (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.autoCreateTopicsEnable = props.getBoolean("auto.create.topics.enable", true);
        this.controllerSocketTimeoutMs = props.getInt("controller.socket.timeout.ms", 30000);
        this.controllerMessageQueueSize = props.getInt("controller.message.queue.size", 10);
        this.defaultReplicationFactor = props.getInt("default.replication.factor", 1);
        this.replicaLagTimeMaxMs = props.getLong("replica.lag.time.max.ms", 10000L);
        this.replicaLagMaxMessages = props.getLong("replica.lag.max.messages", 4000L);
        this.replicaSocketTimeoutMs = props.getInt("replica.socket.timeout.ms", ConsumerConfig$.MODULE$.SocketTimeout());
        this.replicaSocketReceiveBufferBytes = props.getInt("replica.socket.receive.buffer.bytes", ConsumerConfig$.MODULE$.SocketBufferSize());
        this.replicaFetchMaxBytes = props.getIntInRange("replica.fetch.max.bytes", ConsumerConfig$.MODULE$.FetchSize(), (Tuple2<Object, Object>)new Tuple2.mcII.sp(this.messageMaxBytes(), Integer.MAX_VALUE));
        this.replicaFetchWaitMaxMs = props.getInt("replica.fetch.wait.max.ms", 500);
        Predef$.MODULE$.require((long)this.replicaFetchWaitMaxMs() <= this.replicaLagTimeMaxMs(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "replica.fetch.wait.max.ms should always be at least replica.lag.time.max.ms to prevent frequent changes in ISR";
            }
        });
        this.replicaFetchMinBytes = props.getInt("replica.fetch.min.bytes", 1);
        this.numReplicaFetchers = props.getInt("num.replica.fetchers", 1);
        this.replicaHighWatermarkCheckpointIntervalMs = props.getLong("replica.high.watermark.checkpoint.interval.ms", 5000L);
        this.fetchPurgatoryPurgeIntervalRequests = props.getInt("fetch.purgatory.purge.interval.requests", 10000);
        this.producerPurgatoryPurgeIntervalRequests = props.getInt("producer.purgatory.purge.interval.requests", 10000);
        this.autoLeaderRebalanceEnable = props.getBoolean("auto.leader.rebalance.enable", false);
        this.leaderImbalancePerBrokerPercentage = props.getInt("leader.imbalance.per.broker.percentage", 10);
        this.leaderImbalanceCheckIntervalSeconds = props.getInt("leader.imbalance.check.interval.seconds", 300);
        this.controlledShutdownMaxRetries = props.getInt("controlled.shutdown.max.retries", 3);
        this.controlledShutdownRetryBackoffMs = props.getInt("controlled.shutdown.retry.backoff.ms", 5000);
        this.controlledShutdownEnable = props.getBoolean("controlled.shutdown.enable", false);
        this.offsetMetadataMaxSize = props.getInt("offset.metadata.max.bytes", 1024);
    }

    public KafkaConfig(Properties originalProps) {
        this(new VerifiableProperties(originalProps));
        this.props().verify();
    }
}

