/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class KafkaProducer
extends DefaultProducer {
    protected Producer<String, String> producer;
    private final KafkaEndpoint endpoint;

    public KafkaProducer(KafkaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStop() throws Exception {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createProducerProperties();
        props.put("metadata.broker.list", this.endpoint.getBrokers());
        return props;
    }

    protected void doStart() throws Exception {
        Properties props = this.getProps();
        ProducerConfig config = new ProducerConfig(props);
        this.producer = new Producer(config);
    }

    public void process(Exchange exchange) throws CamelException {
        Object partitionKey = exchange.getIn().getHeader("kafka.PARTITION_KEY");
        if (partitionKey == null) {
            throw new CamelExchangeException("No partition key set", exchange);
        }
        String topic = (String)exchange.getIn().getHeader("kafka.TOPIC", (Object)this.endpoint.getTopic(), String.class);
        if (topic == null) {
            throw new CamelExchangeException("No topic key set", exchange);
        }
        String msg = (String)exchange.getIn().getBody(String.class);
        KeyedMessage data = new KeyedMessage(topic, (Object)partitionKey.toString(), (Object)msg);
        this.producer.send(data);
    }
}

