/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.trapd.Snmpv3User;
import org.opennms.netmgt.config.trapd.TrapdConfiguration;
import org.opennms.netmgt.snmp.BasicTrapProcessorFactory;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.trapd.TrapNotificationHandler;
import org.opennms.netmgt.trapd.TrapReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapReceiverImpl
implements TrapReceiver,
TrapNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(TrapReceiverImpl.class);
    @Resource(name="snmpTrapAddress")
    private String m_snmpTrapAddress;
    @Resource(name="snmpTrapPort")
    private Integer m_snmpTrapPort;
    private final List<SnmpV3User> m_snmpV3Users = Collections.synchronizedList(new ArrayList());
    private boolean m_registeredForTraps;
    private List<TrapNotificationHandler> m_trapNotificationHandlers = new ArrayList<TrapNotificationHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrapdConfig(TrapdConfiguration newTrapdConfig) {
        if (this.checkForTrapdConfigurationChange(newTrapdConfig)) {
            LOG.info("Stopping TrapReceiver service to reload configuration...");
            this.stop();
            LOG.info("TrapReceiver service has been stopped.");
            this.m_snmpTrapPort = newTrapdConfig.getSnmpTrapPort();
            this.m_snmpTrapAddress = newTrapdConfig.getSnmpTrapAddress();
            List<SnmpV3User> list = this.m_snmpV3Users;
            synchronized (list) {
                this.m_snmpV3Users.clear();
                if (newTrapdConfig.getSnmpv3UserCollection() != null) {
                    this.m_snmpV3Users.addAll(newTrapdConfig.getSnmpv3UserCollection().stream().map(TrapReceiverImpl::toSnmpV3User).collect(Collectors.toList()));
                }
            }
            LOG.info("Restarting the TrapReceiver service...");
            this.start();
            LOG.info("TrapReceiver service has been restarted.");
        }
    }

    public static boolean isSnmpV3UsersMapUpdated(Map<String, SnmpV3User> existingSnmpV3UserMap, Map<String, SnmpV3User> updatedSnmpV3Usermap) {
        if (updatedSnmpV3Usermap.isEmpty()) {
            return false;
        }
        return !existingSnmpV3UserMap.equals(updatedSnmpV3Usermap);
    }

    protected boolean checkForTrapdConfigurationChange(TrapdConfiguration trapdConfiguration) {
        if (trapdConfiguration.getSnmpTrapPort() != this.m_snmpTrapPort.intValue()) {
            LOG.info("SNMP trap port has been updated from trapd-confguration.xml.");
            return true;
        }
        if (trapdConfiguration.getSnmpTrapAddress() != null && !trapdConfiguration.getSnmpTrapAddress().equalsIgnoreCase("*") && !trapdConfiguration.getSnmpTrapAddress().equalsIgnoreCase(this.m_snmpTrapAddress)) {
            LOG.info("SNMP trap address has been updated from trapd-confguration.xml.");
            return true;
        }
        Map<String, SnmpV3User> newSnmpV3Users = TrapReceiverImpl.getSnmpV3UserMap(trapdConfiguration);
        Map<String, SnmpV3User> existingSnmpV3Users = this.m_snmpV3Users.stream().collect(Collectors.toMap(SnmpV3User::getSecurityName, Function.identity(), (a, b) -> {
            LOG.warn("Multiple SNMPv3 user entries found for security name \"{}\", using entry {}", (Object)a.getSecurityName(), a);
            return a;
        }));
        if (TrapReceiverImpl.isSnmpV3UsersMapUpdated(existingSnmpV3Users, newSnmpV3Users)) {
            LOG.info("SNMPv3 user list has been updated from trapd-confguration.xml.");
            return true;
        }
        return false;
    }

    public TrapReceiverImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrapReceiverImpl(TrapdConfig config) throws SocketException {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.m_snmpTrapPort = config.getSnmpTrapPort();
        this.m_snmpTrapAddress = config.getSnmpTrapAddress();
        List<SnmpV3User> list = this.m_snmpV3Users;
        synchronized (list) {
            this.m_snmpV3Users.clear();
            this.m_snmpV3Users.addAll(config.getSnmpV3Users());
        }
    }

    public TrapNotificationHandler getTrapNotificationHandlers() {
        return this.m_trapNotificationHandlers.get(0);
    }

    public void setTrapNotificationHandlers(TrapNotificationHandler handler) {
        this.m_trapNotificationHandlers = Collections.singletonList(handler);
    }

    public void trapReceived(TrapNotification trapNotification) {
        try {
            for (TrapNotificationHandler handler : this.m_trapNotificationHandlers) {
                handler.handleTrapNotification(trapNotification);
            }
        }
        catch (Throwable e) {
            LOG.error("Handler execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public void trapError(int error, String msg) {
        LOG.warn("Error Processing Received Trap: error = {} {}", (Object)error, (Object)(msg != null ? ", ref = " + msg : ""));
    }

    @Override
    public void start() {
        try {
            InetAddress address = this.getInetAddress();
            LOG.info("Listening on {}:{}", (Object)(address == null ? "[all interfaces]" : InetAddressUtils.str((InetAddress)address)), (Object)this.m_snmpTrapPort);
            SnmpUtils.registerForTraps((TrapNotificationListener)this, (TrapProcessorFactory)new BasicTrapProcessorFactory(), (InetAddress)address, (int)this.m_snmpTrapPort, this.m_snmpV3Users);
            this.m_registeredForTraps = true;
            LOG.debug("init: Creating the trap session");
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                Logging.withPrefix((String)"OpenNMS.Manager", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LOG.error("init: Failed to listen on SNMP trap port {}, perhaps something else is already listening?", (Object)TrapReceiverImpl.this.m_snmpTrapPort, (Object)e);
                    }
                });
                LOG.error("init: Failed to listen on SNMP trap port {}, perhaps something else is already listening?", (Object)this.m_snmpTrapPort, (Object)e);
                throw new UndeclaredThrowableException(e, "Failed to listen on SNMP trap port " + this.m_snmpTrapPort + ", perhaps something else is already listening?");
            }
            LOG.error("init: Failed to initialize SNMP trap socket on port {}", (Object)this.m_snmpTrapPort, (Object)e);
            throw new UndeclaredThrowableException(e, "Failed to initialize SNMP trap socket on port " + this.m_snmpTrapPort);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.m_registeredForTraps) {
                LOG.debug("stop: Closing SNMP trap session.");
                SnmpUtils.unregisterForTraps((TrapNotificationListener)this, (InetAddress)this.getInetAddress(), (int)this.m_snmpTrapPort);
                LOG.debug("stop: SNMP trap session closed.");
            } else {
                LOG.debug("stop: not attemping to closing SNMP trap session--it was never opened");
            }
        }
        catch (IOException e) {
            LOG.warn("stop: exception occurred closing session", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.debug("stop: The SNMP session was already closed", (Throwable)e);
        }
    }

    private InetAddress getInetAddress() {
        if (this.m_snmpTrapAddress.equals("*")) {
            return null;
        }
        return InetAddressUtils.addr((String)this.m_snmpTrapAddress);
    }

    private static Map<String, SnmpV3User> getSnmpV3UserMap(TrapdConfiguration config) {
        if (config.getSnmpv3UserCollection() != null) {
            return config.getSnmpv3UserCollection().stream().collect(Collectors.toMap(Snmpv3User::getSecurityName, TrapReceiverImpl::toSnmpV3User, (a, b) -> {
                LOG.warn("Multiple SNMPv3 user entries found for security name \"{}\", using entry {}", (Object)a.getSecurityName(), a);
                return a;
            }));
        }
        return Collections.emptyMap();
    }

    public static SnmpV3User toSnmpV3User(Snmpv3User snmpv3User) {
        SnmpV3User snmpV3User = new SnmpV3User();
        snmpV3User.setAuthPassPhrase(snmpv3User.getAuthPassphrase());
        snmpV3User.setAuthProtocol(snmpv3User.getAuthProtocol());
        snmpV3User.setEngineId(snmpv3User.getEngineId());
        snmpV3User.setPrivPassPhrase(snmpv3User.getPrivacyPassphrase());
        snmpV3User.setPrivProtocol(snmpv3User.getPrivacyProtocol());
        snmpV3User.setSecurityName(snmpv3User.getSecurityName());
        return snmpV3User;
    }
}

