/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel;

import java.util.Objects;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.camel.CamelMessageConsumerManager;

public class CamelSinkServerProcessor
implements AsyncProcessor {
    private final CamelMessageConsumerManager consumerManager;
    private final SinkModule<Message> module;

    public CamelSinkServerProcessor(CamelMessageConsumerManager consumerManager, SinkModule<Message> module) {
        this.consumerManager = Objects.requireNonNull(consumerManager);
        this.module = Objects.requireNonNull(module);
    }

    public void process(Exchange exchange) {
        throw new UnsupportedOperationException("This processor must be invoked using the async interface.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        String messageAsString = (String)exchange.getIn().getBody(String.class);
        try {
            Message message = this.module.unmarshal(messageAsString);
            this.consumerManager.dispatch(this.module, message);
        }
        catch (Throwable t) {
            exchange.setException(t);
        }
        finally {
            callback.done(false);
        }
        return false;
    }
}

