/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.opennms.netmgt.provision.support.DetectRequestImpl;
import org.opennms.netmgt.provision.support.GenericServiceDetectorFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GenericSnmpDetectorFactory<T extends SnmpDetector>
extends GenericServiceDetectorFactory<SnmpDetector> {
    @Autowired(required=false)
    private SnmpAgentConfigFactory m_agentConfigFactory;

    public GenericSnmpDetectorFactory(Class<T> clazz) {
        super(clazz);
    }

    public T createDetector() {
        return (T)((Object)((SnmpDetector)super.createDetector()));
    }

    public DetectRequest buildRequest(String location, InetAddress address, Integer port) {
        return new DetectRequestImpl(address, port, this.getRuntimeAttributes(location, address, port));
    }

    public Map<String, String> getRuntimeAttributes(String location, InetAddress address, Integer port) {
        if (this.m_agentConfigFactory == null) {
            throw new IllegalStateException("Cannot determine agent configuration without a SnmpAgentConfigFactory.");
        }
        return this.m_agentConfigFactory.getAgentConfig(address, location).toMap();
    }

    public void setAgentConfigFactory(SnmpAgentConfigFactory agentConfigFactory) {
        this.m_agentConfigFactory = agentConfigFactory;
    }
}

