/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiscoIpSlaDetector
extends SnmpDetector {
    private static final Logger LOG = LoggerFactory.getLogger(CiscoIpSlaDetector.class);
    private static final String PROTOCOL_NAME = "Cisco_IP_SLA";
    private static final int RTT_MON_OPER_STATE_ACTIVE = 6;
    private static final String RTT_ADMIN_TAG_OID = ".1.3.6.1.4.1.9.9.42.1.2.1.1.3";
    private static final String RTT_OPER_STATE_OID = ".1.3.6.1.4.1.9.9.42.1.2.9.1.10";
    private String m_adminTag;

    public CiscoIpSlaDetector() {
        this.setServiceName(PROTOCOL_NAME);
    }

    @Override
    public boolean isServiceDetected(InetAddress address, SnmpAgentConfig agentConfig) {
        try {
            this.configureAgentPTR(agentConfig);
            this.configureAgentVersion(agentConfig);
            Map tagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaDetector", (SnmpObjId)SnmpObjId.get((String)RTT_ADMIN_TAG_OID));
            if (tagResults == null) {
                LOG.warn("isServiceDetected: No admin tags received!");
                return false;
            }
            Map operStateResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaDetector", (SnmpObjId)SnmpObjId.get((String)RTT_OPER_STATE_OID));
            if (operStateResults == null) {
                LOG.warn("isServiceDetected: No operational states received!");
                return false;
            }
            for (Map.Entry ipslaEntry : tagResults.entrySet()) {
                SnmpValue status = (SnmpValue)operStateResults.get(ipslaEntry.getKey());
                LOG.debug("isServiceDetected: admin-tag={} value={} oper-state={}", new Object[]{this.m_adminTag, this.formatValue((SnmpValue)ipslaEntry.getValue()), status.toInt()});
                if (!this.m_adminTag.equals(this.formatValue((SnmpValue)ipslaEntry.getValue())) || status.toInt() != 6) continue;
                LOG.debug("isServiceDetected: admin tag found");
                return true;
            }
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        return false;
    }

    private String formatValue(SnmpValue value) {
        return value.isNull() ? null : value.toString().replaceAll("\"", "");
    }

    public String getAdminTag() {
        return this.m_adminTag;
    }

    public void setAdminTag(String adminTag) {
        this.m_adminTag = adminTag;
    }
}

