/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.many;

import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.core.mappings.CoreAttributeAccessor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.jaxb.many.MapEntry;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class MapValueAttributeAccessor
extends AttributeAccessor {
    private CoreAttributeAccessor nestedAccessor;
    private String mapClassName;
    private Class mapClass;
    private CoreContainerPolicy containerPolicy;
    private Class generatedEntryClass;
    private ClassLoader classLoader;

    public MapValueAttributeAccessor(CoreAttributeAccessor nestedAccessor, CoreContainerPolicy cp, Class generatedEntryClass, String mapClassName, ClassLoader classLoader) {
        this.nestedAccessor = nestedAccessor;
        this.mapClassName = mapClassName;
        this.containerPolicy = cp;
        this.generatedEntryClass = generatedEntryClass;
        this.classLoader = classLoader;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object value = this.nestedAccessor.getAttributeValueFromObject(object);
        if (value == null) {
            return null;
        }
        Object results = this.containerPolicy.containerInstance(((Map)value).size());
        Set entrySet = ((Map)value).entrySet();
        if (entrySet == null) {
            return results;
        }
        for (Map.Entry entry : entrySet) {
            MapEntry nextEntry;
            try {
                nextEntry = (MapEntry)this.generatedEntryClass.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
            nextEntry.setKey(entry.getKey());
            nextEntry.setValue(entry.getValue());
            this.containerPolicy.addInto((Object)nextEntry, results, null);
        }
        return results;
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        Map mapValue = null;
        try {
            mapValue = (Map)this.mapClass.newInstance();
        }
        catch (InstantiationException e) {
            throw XMLMarshalException.unmarshalException((Exception)e);
        }
        catch (IllegalAccessException e) {
            throw XMLMarshalException.unmarshalException((Exception)e);
        }
        if (value != null) {
            Object iterator = this.containerPolicy.iteratorFor(value);
            while (this.containerPolicy.hasNext(iterator)) {
                Object next = this.containerPolicy.next(iterator, null);
                Object nextKey = ((MapEntry)next).getKey();
                Object nextValue = ((MapEntry)next).getValue();
                mapValue.put(nextKey, nextValue);
            }
        }
        this.nestedAccessor.setAttributeValueInObject(object, (Object)mapValue);
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(theJavaClass);
        if (this.mapClassName.equals("java.util.Map")) {
            this.mapClassName = "java.util.HashMap";
        } else if (this.mapClassName.equals("java.util.concurrent.ConcurrentMap")) {
            this.mapClassName = "java.util.concurrent.ConcurrentHashMap";
        } else if (this.mapClassName.equals("java.util.SortedMap")) {
            this.mapClassName = "java.util.TreeMap";
        }
        try {
            this.mapClass = PrivilegedAccessHelper.getClassForName((String)this.mapClassName, (boolean)true, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw XMLMarshalException.unmarshalException((Exception)e);
        }
    }
}

