/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogDTOToObjectProcessor
implements Processor {
    public static final Logger LOG = LoggerFactory.getLogger(SyslogDTOToObjectProcessor.class);

    public void process(Exchange exchange) throws Exception {
        SyslogDTO object = (SyslogDTO)((Object)exchange.getIn().getBody(SyslogDTO.class));
        exchange.getIn().setBody((Object)SyslogDTOToObjectProcessor.dto2object(object), SyslogConnection.class);
    }

    public static SyslogConnection dto2object(SyslogDTO syslogDto) {
        SyslogConnection syslog = new SyslogConnection();
        syslog.setLocation(syslogDto.getHeader("location"));
        syslog.setSourceAddress(InetAddressUtils.getInetAddress((String)syslogDto.getHeader("sourceAddress")));
        syslog.setPort(Integer.parseInt(syslogDto.getHeader("sourcePort")));
        syslog.setSystemId(syslogDto.getHeader("systemId"));
        if (syslogDto.getBody() != null && syslogDto.getBody().length > 0) {
            syslog.setBytes(syslogDto.getBody());
        }
        return syslog;
    }
}

