/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spi.Synchronization;
import org.opennms.core.rpc.api.RequestTimedOutException;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.rpc.camel.CamelRpcRequest;

public class CamelRpcClientFactory
implements RpcClientFactory {
    private String location;
    @EndpointInject(uri="direct:executeRpc", context="rpcClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:executeRpc", context="rpcClient")
    private Endpoint endpoint;

    public <S extends RpcRequest, T extends RpcResponse> RpcClient<S, T> getClient(final RpcModule<S, T> module) {
        return new RpcClient<S, T>(){

            public CompletableFuture<T> execute(S request) {
                if (request.getLocation() == null || request.getLocation().equals(CamelRpcClientFactory.this.location)) {
                    return module.execute(request);
                }
                final CompletableFuture future = new CompletableFuture();
                CamelRpcClientFactory.this.template.asyncCallbackSendBody(CamelRpcClientFactory.this.endpoint, new CamelRpcRequest(module, request), new Synchronization(){

                    public void onComplete(Exchange exchange) {
                        try {
                            future.complete(module.unmarshalResponse((String)exchange.getOut().getBody(String.class)));
                        }
                        catch (Throwable ex) {
                            future.completeExceptionally(ex);
                        }
                    }

                    public void onFailure(Exchange exchange) {
                        ExchangeTimedOutException timeoutException = (ExchangeTimedOutException)exchange.getException(ExchangeTimedOutException.class);
                        if (timeoutException != null) {
                            future.completeExceptionally((Throwable)new RequestTimedOutException((Throwable)exchange.getException()));
                        } else {
                            future.completeExceptionally(exchange.getException());
                        }
                    }
                });
                return future;
            }
        };
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

