/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.collections.RadixTreeNode;

public class RadixTreeNodeImpl<T>
implements RadixTreeNode<T> {
    private static final String TO_STRING_INDENT = "  ";
    private T content;
    private final Set<RadixTreeNode<T>> children = new LinkedHashSet<RadixTreeNode<T>>();

    public RadixTreeNodeImpl(T content, Collection<RadixTreeNode<T>> children) {
        this.content = content;
        this.children.addAll(children);
    }

    public RadixTreeNodeImpl(T[] chain) {
        this.content = chain[0];
        if (chain.length > 1) {
            this.children.add(new RadixTreeNodeImpl<T>(Arrays.copyOfRange(chain, 1, chain.length)));
        }
    }

    @Override
    public T getContent() {
        return this.content;
    }

    @Override
    public void setContent(T newContent) {
        this.content = newContent;
    }

    @Override
    public void addChildren(T[] chain) {
        T head = chain[0];
        for (RadixTreeNode<T> node : this.children) {
            if (!head.equals(node.getContent()) || chain.length == 1) continue;
            node.addChildren(Arrays.copyOfRange(chain, 1, chain.length));
            return;
        }
        RadixTreeNodeImpl<T> newNode = new RadixTreeNodeImpl<T>(chain);
        this.children.add(newNode);
    }

    @Override
    public Set<RadixTreeNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Set<RadixTreeNode<T>> newChildren) {
        this.children.clear();
        this.children.addAll(newChildren);
    }

    @Override
    public int size() {
        int retval = this.getChildren().stream().collect(Collectors.summingInt(RadixTreeNode::size));
        return this.content == null ? retval : ++retval;
    }

    @Override
    public String toStringWithPrefix(String prefix) {
        StringBuffer value = new StringBuffer();
        value.append(this.content == null ? "" : this.content.toString()).append("\n");
        for (RadixTreeNode<T> child : this.children) {
            value.append(prefix).append(child.toStringWithPrefix(prefix + TO_STRING_INDENT));
        }
        return value.toString();
    }

    public String toString() {
        return this.toStringWithPrefix("");
    }
}

