/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.spi.Synchronization;
import org.opennms.core.logging.Logging;
import org.opennms.core.rpc.api.RemoteExecutionException;
import org.opennms.core.rpc.api.RequestRejectedException;
import org.opennms.core.rpc.api.RequestTimedOutException;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.rpc.camel.CamelRpcRequest;
import org.opennms.core.rpc.camel.CamelRpcServerProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelRpcClientFactory
implements RpcClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcServerProcessor.class);
    private String location;
    @EndpointInject(uri="direct:executeRpc", context="rpcClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:executeRpc", context="rpcClient")
    private Endpoint endpoint;

    public <S extends RpcRequest, T extends RpcResponse> RpcClient<S, T> getClient(final RpcModule<S, T> module) {
        return new RpcClient<S, T>(){

            public CompletableFuture<T> execute(S request) {
                if (request.getLocation() == null || request.getLocation().equals(CamelRpcClientFactory.this.location)) {
                    return module.execute(request);
                }
                final Map clientContextMap = Logging.getCopyOfContextMap();
                final CompletableFuture future = new CompletableFuture();
                CamelRpcClientFactory.this.template.asyncCallbackSendBody(CamelRpcClientFactory.this.endpoint, new CamelRpcRequest(module, request), new Synchronization(){

                    public void onComplete(Exchange exchange) {
                        try (Logging.MDCCloseable mdc = Logging.withContextMapCloseable((Map)clientContextMap);){
                            RpcResponse response = module.unmarshalResponse((String)exchange.getOut().getBody(String.class));
                            if (response.getErrorMessage() != null) {
                                future.completeExceptionally((Throwable)new RemoteExecutionException(response.getErrorMessage()));
                            } else {
                                future.complete(response);
                            }
                        }
                        catch (Throwable ex) {
                            LOG.error("Unmarshalling a response in RPC module {} failed.", (Object)module, (Object)ex);
                            future.completeExceptionally(ex);
                        }
                        Logging.putPrefix((String)"ipc");
                    }

                    public void onFailure(Exchange exchange) {
                        try (Logging.MDCCloseable mdc = Logging.withContextMapCloseable((Map)clientContextMap);){
                            ExchangeTimedOutException timeoutException = (ExchangeTimedOutException)exchange.getException(ExchangeTimedOutException.class);
                            DirectConsumerNotAvailableException directConsumerNotAvailableException = (DirectConsumerNotAvailableException)exchange.getException(DirectConsumerNotAvailableException.class);
                            if (timeoutException != null) {
                                future.completeExceptionally((Throwable)new RequestTimedOutException((Throwable)exchange.getException()));
                            } else if (directConsumerNotAvailableException != null) {
                                future.completeExceptionally((Throwable)new RequestRejectedException((Throwable)exchange.getException()));
                            } else {
                                future.completeExceptionally(exchange.getException());
                            }
                        }
                        Logging.putPrefix((String)"ipc");
                    }
                });
                return future;
            }
        };
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

