/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.List;
import java.util.Objects;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageDispatcherFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.trapd.TrapdConfiguration;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.TrapInformation;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.trapd.TrapInformationWrapper;
import org.opennms.netmgt.trapd.TrapSinkConsumer;
import org.opennms.netmgt.trapd.TrapSinkModule;
import org.opennms.netmgt.trapd.TrapdConfigBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TrapListener
implements TrapNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(TrapListener.class);
    @Autowired
    private MessageDispatcherFactory m_messageDispatcherFactory;
    @Autowired
    private DistPollerDao m_distPollerDao;
    private boolean m_registeredForTraps;
    private TrapdConfig m_config;
    private AsyncDispatcher<TrapInformationWrapper> m_dispatcher;

    public TrapListener(TrapdConfig config) throws SocketException {
        Objects.requireNonNull(config, "Config cannot be null");
        this.m_config = config;
    }

    public void trapReceived(TrapInformation trapInformation) {
        try {
            this.getMessageDispatcher().send((Message)new TrapInformationWrapper(trapInformation)).whenComplete((t, ex) -> {
                if (ex != null) {
                    LOG.error("An error occured while forwarding trap {} for further processing. The trap will be dropped.", (Object)trapInformation, ex);
                    TrapSinkConsumer.trapdInstrumentation.incErrorCount();
                }
            });
        }
        catch (IllegalArgumentException ex2) {
            LOG.error("Received trap {} is not valid and cannot be processed. The trap will be dropped.", (Object)trapInformation, (Object)ex2);
            TrapSinkConsumer.trapdInstrumentation.incErrorCount();
        }
    }

    public void trapError(int error, String msg) {
        LOG.warn("Error Processing Received Trap: error = {} {}", (Object)error, (Object)(msg != null ? ", ref = " + msg : ""));
    }

    public void start() {
        final int m_snmpTrapPort = this.m_config.getSnmpTrapPort();
        InetAddress address = this.getInetAddress();
        try {
            LOG.info("Listening on {}:{}", (Object)(address == null ? "[all interfaces]" : InetAddressUtils.str((InetAddress)address)), (Object)m_snmpTrapPort);
            SnmpUtils.registerForTraps((TrapNotificationListener)this, (InetAddress)address, (int)m_snmpTrapPort, (List)this.m_config.getSnmpV3Users());
            this.m_registeredForTraps = true;
            LOG.debug("init: Creating the trap session");
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                Logging.withPrefix((String)"OpenNMS.Manager", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LOG.error("init: Failed to listen on SNMP trap port {}, perhaps something else is already listening?", (Object)m_snmpTrapPort, (Object)e);
                    }
                });
                LOG.error("init: Failed to listen on SNMP trap port {}, perhaps something else is already listening?", (Object)m_snmpTrapPort, (Object)e);
                throw new UndeclaredThrowableException(e, "Failed to listen on SNMP trap port " + m_snmpTrapPort + ", perhaps something else is already listening?");
            }
            LOG.error("init: Failed to initialize SNMP trap socket on port {}", (Object)m_snmpTrapPort, (Object)e);
            throw new UndeclaredThrowableException(e, "Failed to initialize SNMP trap socket on port " + m_snmpTrapPort);
        }
    }

    public void stop() {
        try {
            if (this.m_registeredForTraps) {
                LOG.debug("stop: Closing SNMP trap session.");
                SnmpUtils.unregisterForTraps((TrapNotificationListener)this, (InetAddress)this.getInetAddress(), (int)this.m_config.getSnmpTrapPort());
                this.m_registeredForTraps = false;
                LOG.debug("stop: SNMP trap session closed.");
            } else {
                LOG.debug("stop: not attemping to closing SNMP trap session--it was never opened or already closed.");
            }
            if (this.m_dispatcher != null) {
                this.m_dispatcher.close();
                this.m_dispatcher = null;
            }
        }
        catch (IOException e) {
            LOG.warn("stop: exception occurred closing session", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.debug("stop: The SNMP session was already closed", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("stop: exception occured closing m_dispatcher", (Throwable)e);
        }
    }

    public void setTrapdConfig(TrapdConfiguration newTrapdConfig) {
        TrapdConfigBean newTrapdConfigBean = new TrapdConfigBean(newTrapdConfig);
        if (this.hasConfigurationChanged(newTrapdConfigBean)) {
            this.restartWithNewConfig(newTrapdConfigBean);
        }
    }

    public void setSnmpV3Users(TrapdConfiguration newTrapdConfig) {
        TrapdConfigBean newTrapdConfigBean = new TrapdConfigBean(newTrapdConfig);
        if (this.hasSnmpV3UsersChanged(newTrapdConfigBean)) {
            TrapdConfigBean clone = new TrapdConfigBean(this.m_config);
            clone.setSnmpV3Users(newTrapdConfigBean.getSnmpV3Users());
            this.restartWithNewConfig(clone);
        }
    }

    public void setMessageDispatcherFactory(MessageDispatcherFactory messageDispatcherFactory) {
        this.m_messageDispatcherFactory = Objects.requireNonNull(messageDispatcherFactory);
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = Objects.requireNonNull(distPollerDao);
    }

    private void restartWithNewConfig(TrapdConfigBean newConfig) {
        LOG.info("Stopping TrapListener service to reload configuration...");
        this.stop();
        LOG.info("TrapListener service has been stopped.");
        this.m_config.update((TrapdConfig)newConfig);
        LOG.info("Restarting the TrapListener service...");
        this.start();
        LOG.info("TrapListener service has been restarted.");
    }

    private InetAddress getInetAddress() {
        if (this.m_config.getSnmpTrapAddress().equals("*")) {
            return null;
        }
        return InetAddressUtils.addr((String)this.m_config.getSnmpTrapAddress());
    }

    private AsyncDispatcher<TrapInformationWrapper> getMessageDispatcher() {
        if (this.m_dispatcher == null) {
            Objects.requireNonNull(this.m_messageDispatcherFactory);
            this.m_dispatcher = this.m_messageDispatcherFactory.createAsyncDispatcher((SinkModule)new TrapSinkModule(this.m_config, this.m_distPollerDao.whoami()));
        }
        return this.m_dispatcher;
    }

    protected boolean hasConfigurationChanged(TrapdConfig newConfig) {
        if (newConfig.getSnmpTrapPort() != this.m_config.getSnmpTrapPort()) {
            LOG.info("SNMP trap port has been updated from trapd-confguration.xml.");
            return true;
        }
        if (newConfig.getSnmpTrapAddress() != null && !newConfig.getSnmpTrapAddress().equalsIgnoreCase("*") && !newConfig.getSnmpTrapAddress().equalsIgnoreCase(this.m_config.getSnmpTrapAddress())) {
            LOG.info("SNMP trap address has been updated from trapd-confguration.xml.");
            return true;
        }
        return this.hasSnmpV3UsersChanged(newConfig);
    }

    public boolean hasSnmpV3UsersChanged(TrapdConfig newConfig) {
        if (newConfig.getSnmpV3Users().isEmpty()) {
            return false;
        }
        return !newConfig.getSnmpV3Users().equals(this.m_config.getSnmpV3Users());
    }
}

