/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.statsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.statsd.Parameter;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="report")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="statistics-daemon-configuration.xsd")
public class Report
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="class-name", required=true)
    private String m_className;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = ConfigUtils.assertNotEmpty(className, "class-name");
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        if (parameters == this.m_parameters) {
            return;
        }
        this.m_parameters.clear();
        if (parameters != null) {
            this.m_parameters.addAll(parameters);
        }
    }

    public void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_className, this.m_parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Report) {
            Report that = (Report)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_className, that.m_className) && Objects.equals(this.m_parameters, that.m_parameters);
        }
        return false;
    }
}

