/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.transport.FrameBody;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.framing.TransportFrame;

class FrameWriter {
    static final byte AMQP_FRAME_TYPE = 0;
    static final byte SASL_FRAME_TYPE = 1;
    private EncoderImpl _encoder;
    private ByteBuffer _bbuf;
    private WritableBuffer _buffer;
    private int _maxFrameSize;
    private byte _frameType;
    private ProtocolTracer _protocolTracer;
    private Object _logCtx;
    private int _frameStart = 0;
    private int _payloadStart;
    private int _performativeSize;

    FrameWriter(EncoderImpl encoder, int maxFrameSize, byte frameType, ProtocolTracer protocolTracer, Object logCtx) {
        this._encoder = encoder;
        this._bbuf = ByteBuffer.allocate(1024);
        this._buffer = new WritableBuffer.ByteBufferWrapper(this._bbuf);
        this._encoder.setByteBuffer(this._buffer);
        this._maxFrameSize = maxFrameSize;
        this._frameType = frameType;
        this._protocolTracer = protocolTracer;
        this._logCtx = logCtx;
    }

    void setMaxFrameSize(int maxFrameSize) {
        this._maxFrameSize = maxFrameSize;
    }

    private void grow() {
        ByteBuffer old = this._bbuf;
        this._bbuf = ByteBuffer.allocate(this._bbuf.capacity() * 2);
        this._buffer = new WritableBuffer.ByteBufferWrapper(this._bbuf);
        old.flip();
        this._bbuf.put(old);
        this._encoder.setByteBuffer(this._buffer);
    }

    void writeHeader(byte[] header) {
        this._buffer.put(header, 0, header.length);
    }

    private void startFrame() {
        this._frameStart = this._buffer.position();
    }

    private void writePerformative(Object frameBody) {
        while (this._buffer.remaining() < 8) {
            this.grow();
        }
        while (true) {
            try {
                this._buffer.position(this._frameStart + 8);
                this._encoder.writeObject(frameBody);
            }
            catch (BufferOverflowException e) {
                this.grow();
                continue;
            }
            break;
        }
        this._payloadStart = this._buffer.position();
        this._performativeSize = this._payloadStart - this._frameStart;
    }

    private void endFrame(int channel) {
        int frameSize = this._buffer.position() - this._frameStart;
        int limit = this._buffer.position();
        this._buffer.position(this._frameStart);
        this._buffer.putInt(frameSize);
        this._buffer.put((byte)2);
        this._buffer.put(this._frameType);
        this._buffer.putShort((short)channel);
        this._buffer.position(limit);
        int offset = this._bbuf.arrayOffset() + this._frameStart;
    }

    void writeFrame(int channel, Object frameBody, ByteBuffer payload, Runnable onPayloadTooLarge) {
        int capacity;
        int payloadSize;
        this.startFrame();
        this.writePerformative(frameBody);
        if (this._maxFrameSize > 0 && payload != null && payload.remaining() + this._performativeSize > this._maxFrameSize) {
            if (onPayloadTooLarge != null) {
                onPayloadTooLarge.run();
            }
            this.writePerformative(frameBody);
        }
        ByteBuffer originalPayload = null;
        if (payload != null) {
            originalPayload = payload.duplicate();
        }
        if (this._frameType == 0) {
            TransportFrame frame = new TransportFrame(channel, (FrameBody)frameBody, Binary.create(originalPayload));
            TransportImpl.log(this._logCtx, TransportImpl.OUTGOING, frame);
            if (this._protocolTracer != null) {
                this._protocolTracer.sentFrame(frame);
            }
        }
        if ((payloadSize = Math.min(payload == null ? 0 : payload.remaining(), capacity = this._maxFrameSize > 0 ? this._maxFrameSize - this._performativeSize : Integer.MAX_VALUE)) > 0) {
            while (this._buffer.remaining() < payloadSize) {
                this.grow();
            }
            int oldLimit = payload.limit();
            payload.limit(payload.position() + payloadSize);
            this._buffer.put(payload);
            payload.limit(oldLimit);
        }
        this.endFrame(channel);
    }

    void writeFrame(Object frameBody) {
        this.writeFrame(0, frameBody, null, null);
    }

    int readBytes(ByteBuffer dst) {
        ByteBuffer src = this._bbuf.duplicate();
        src.flip();
        int size2 = Math.min(src.remaining(), dst.remaining());
        int limit = src.limit();
        src.limit(size2);
        dst.put(src);
        src.limit(limit);
        this._bbuf.rewind();
        this._bbuf.put(src);
        return size2;
    }
}

