/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="", propOrder={"m_rras"})
@XmlRootElement(name="rrd")
@ValidateUsing(value="wmi-datacollection.xsd")
public class Rrd
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="rra", required=true)
    protected List<String> m_rras = new ArrayList<String>();
    @XmlAttribute(name="step", required=true)
    protected Integer m_step;

    public List<String> getRra() {
        return this.m_rras;
    }

    public void setRra(List<String> rras) {
        if (rras == this.m_rras) {
            return;
        }
        this.m_rras.clear();
        if (rras != null) {
            for (String rra : rras) {
                this.addRra(rra);
            }
        }
    }

    public void addRra(String rra) {
        Pattern pattern = Pattern.compile("^RRA:(AVERAGE|MIN|MAX|LAST):.*$");
        this.m_rras.add(ConfigUtils.assertMatches(ConfigUtils.assertNotNull(rra, "rra"), pattern, "rra"));
    }

    public boolean removeRra(String rra) {
        return this.m_rras.remove(rra);
    }

    public Integer getStep() {
        return this.m_step;
    }

    public void setStep(Integer step) {
        this.m_step = (Integer)ConfigUtils.assertMinimumInclusive((Number)ConfigUtils.assertNotNull(step, "step"), 1L, "step");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rrd)) {
            return false;
        }
        Rrd that = (Rrd)obj;
        return Objects.equals(this.m_rras, that.m_rras) && Objects.equals(this.m_step, that.m_step);
    }

    public int hashCode() {
        return Objects.hash(this.m_rras, this.m_step);
    }
}

