/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import org.apache.camel.com.googlecode.concurrentlinkedhashmap.EvictionListener;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCache<K, V>
implements Map<K, V>,
EvictionListener<K, V>,
Serializable {
    private static final long serialVersionUID = -342098639681884414L;
    private static final Logger LOG = LoggerFactory.getLogger(LRUCache.class);
    private int maxCacheSize = 10000;
    private boolean stopOnEviction;
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();
    private final AtomicLong evicted = new AtomicLong();
    private ConcurrentLinkedHashMap<K, V> map;

    public LRUCache(int maximumCacheSize) {
        this(16, maximumCacheSize);
    }

    public LRUCache(int initialCapacity, int maximumCacheSize) {
        this(initialCapacity, maximumCacheSize, true);
    }

    public LRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        this.map = new ConcurrentLinkedHashMap.Builder().initialCapacity(initialCapacity).maximumWeightedCapacity(maximumCacheSize).listener(this).build();
        this.maxCacheSize = maximumCacheSize;
        this.stopOnEviction = stopOnEviction;
    }

    @Override
    public V get(Object o) {
        V answer = this.map.get(o);
        if (answer != null) {
            this.hits.incrementAndGet();
        } else {
            this.misses.incrementAndGet();
        }
        return answer;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(0);
    }

    @Override
    public V put(K k, V v) {
        return this.map.put(k, v);
    }

    @Override
    public V remove(Object o) {
        return this.map.remove(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.resetStatistics();
    }

    @Override
    public Set<K> keySet() {
        return this.map.ascendingKeySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.ascendingMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.ascendingMap().entrySet();
    }

    @Override
    public void onEviction(K key, V value) {
        this.evicted.incrementAndGet();
        LOG.trace("onEviction {} -> {}", key, value);
        if (this.stopOnEviction) {
            try {
                ServiceHelper.stopService(value);
            }
            catch (Exception e) {
                LOG.warn("Error stopping service: " + value + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public long getHits() {
        return this.hits.get();
    }

    public long getMisses() {
        return this.misses.get();
    }

    public long getEvicted() {
        return this.evicted.get();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void resetStatistics() {
        this.hits.set(0L);
        this.misses.set(0L);
        this.evicted.set(0L);
    }

    public String toString() {
        return "LRUCache@" + ObjectHelper.getIdentityHashCode(this);
    }
}

