/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.remote.JMXServiceURL;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.config.jmx.MBeanServer;
import org.opennms.netmgt.dao.jmx.JmxConfigDao;
import org.opennms.netmgt.jmx.ParameterName;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfig;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JmxUtils.class);

    public static Map<String, String> convertToUnmodifiableStringMap(Map<String, Object> map) {
        if (map != null) {
            HashMap<String, String> convertedProperties = new HashMap<String, String>();
            for (Map.Entry<String, Object> eachEntry : map.entrySet()) {
                if (eachEntry.getValue() == null) continue;
                convertedProperties.put(eachEntry.getKey(), eachEntry.getValue().toString());
            }
            return Collections.unmodifiableMap(convertedProperties);
        }
        return null;
    }

    public static Map<String, String> convertToStringMap(Map<String, Object> map) {
        if (map != null) {
            HashMap<String, String> convertedProperties = new HashMap<String, String>();
            for (Map.Entry<String, Object> eachEntry : map.entrySet()) {
                if (eachEntry.getValue() == null) continue;
                convertedProperties.put(eachEntry.getKey(), eachEntry.getValue().toString());
            }
            return convertedProperties;
        }
        return null;
    }

    public static String getCollectionDirectory(Map<String, String> map, String friendlyName, String serviceName) {
        Objects.requireNonNull(map, "Map must be initialized!");
        if (friendlyName != null && !friendlyName.isEmpty()) {
            return friendlyName;
        }
        if (serviceName != null && !serviceName.isEmpty()) {
            return serviceName.toLowerCase();
        }
        String port = map.get(ParameterName.PORT.toString());
        return port;
    }

    public static String getGroupName(Map<String, String> map, Mbean mbean) {
        boolean useMbeanForRrds = Boolean.valueOf(map.get(ParameterName.USE_MBEAN_NAME_FOR_RRDS.toString()));
        String groupName = useMbeanForRrds ? mbean.getName() : mbean.getObjectname();
        return groupName;
    }

    public static Map<String, String> getRuntimeAttributes(JmxConfigDao jmxConfigDao, String address, Map<String, String> parameters) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(parameters);
        if (jmxConfigDao != null && jmxConfigDao.getConfig() != null) {
            try {
                JmxConnectionConfig config = JmxConnectionConfigBuilder.buildFrom(address, parameters).build();
                int port = new JMXServiceURL(config.getUrl()).getPort();
                MBeanServer mBeanServer = jmxConfigDao.getConfig().lookupMBeanServer(address, port);
                if (mBeanServer != null) {
                    return new HashMap<String, String>(mBeanServer.getParameterMap());
                }
            }
            catch (MalformedURLException e) {
                LOG.warn("Unexpected exception: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return Collections.emptyMap();
    }

    private JmxUtils() {
    }
}

