/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ErrorStatus;
import org.opennms.netmgt.snmp.ErrorStatusException;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.ToStringBuilder;
import org.opennms.netmgt.snmp.proxy.WalkRequest;
import org.opennms.netmgt.snmp.proxy.WalkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnTracker
extends CollectionTracker {
    private static final transient Logger LOG = LoggerFactory.getLogger(ColumnTracker.class);
    private SnmpObjId m_base;
    private SnmpObjId m_last;
    private int m_maxRepetitions;
    private int m_maxRetries;
    private Integer m_retries;

    public ColumnTracker(SnmpObjId base) {
        this(null, base);
    }

    public ColumnTracker(SnmpObjId base, int maxRepititions, int maxRetries) {
        this(null, base, maxRepititions, maxRetries);
    }

    public ColumnTracker(CollectionTracker parent, SnmpObjId base) {
        this(parent, base, 2, 0);
    }

    public ColumnTracker(CollectionTracker parent, SnmpObjId base, int maxRepititions, int maxRetries) {
        super(parent);
        this.m_base = base;
        this.m_last = base;
        this.m_maxRepetitions = maxRepititions;
        this.m_maxRetries = maxRetries;
    }

    public SnmpObjId getBase() {
        return this.m_base;
    }

    public String toString() {
        return new ToStringBuilder(this).append("base", this.m_base).append("last oid", this.m_last).append("max repetitions", this.m_maxRepetitions).append("finished?", this.isFinished()).toString();
    }

    @Override
    public ResponseProcessor buildNextPdu(PduBuilder pduBuilder) {
        if (pduBuilder.getMaxVarsPerPdu() < 1) {
            throw new IllegalArgumentException("maxVarsPerPdu < 1");
        }
        LOG.debug("Requesting oid following: {}", (Object)this.m_last);
        pduBuilder.addOid(this.m_last);
        pduBuilder.setNonRepeaters(0);
        pduBuilder.setMaxRepetitions(this.getMaxRepetitions());
        ResponseProcessor rp = new ResponseProcessor(){

            @Override
            public void processResponse(SnmpObjId responseObjId, SnmpValue val) {
                SnmpInstId inst;
                if (val.isEndOfMib()) {
                    ColumnTracker.this.receivedEndOfMib();
                    return;
                }
                LOG.debug("Processing varBind: {} = {}", (Object)responseObjId, (Object)val);
                ColumnTracker.this.m_last = responseObjId;
                if (ColumnTracker.this.m_base.isPrefixOf(responseObjId) && !ColumnTracker.this.m_base.equals(responseObjId) && (inst = responseObjId.getInstance(ColumnTracker.this.m_base)) != null) {
                    ColumnTracker.this.storeResult(new SnmpResult(ColumnTracker.this.m_base, inst, val));
                }
                if (!ColumnTracker.this.m_base.isPrefixOf(ColumnTracker.this.m_last)) {
                    ColumnTracker.this.setFinished(true);
                }
            }

            @Override
            public boolean processErrors(int errorStatus, int errorIndex) {
                ErrorStatus status;
                if (ColumnTracker.this.m_retries == null) {
                    ColumnTracker.this.m_retries = ColumnTracker.this.getMaxRetries();
                }
                if ((status = ErrorStatus.fromStatus(errorStatus)) == ErrorStatus.TOO_BIG) {
                    throw new IllegalArgumentException("Unable to handle tooBigError for next oid request after " + ColumnTracker.this.m_last);
                }
                if (status == ErrorStatus.GEN_ERR) {
                    ColumnTracker.this.reportGenErr("Received genErr requesting next oid after " + ColumnTracker.this.m_last + ". Marking column is finished.");
                    ColumnTracker.this.errorOccurred();
                    return true;
                }
                if (status == ErrorStatus.NO_SUCH_NAME) {
                    ColumnTracker.this.reportNoSuchNameErr("Received noSuchName requesting next oid after " + ColumnTracker.this.m_last + ". Marking column is finished.");
                    ColumnTracker.this.errorOccurred();
                    return true;
                }
                if (status.isFatal()) {
                    ErrorStatusException ex = new ErrorStatusException(status, "Unexpected error processing next oid after " + ColumnTracker.this.m_last + ". Aborting!");
                    ColumnTracker.this.reportFatalErr(ex);
                    throw ex;
                }
                if (status != ErrorStatus.NO_ERROR) {
                    ColumnTracker.this.reportNonFatalErr(status);
                }
                if (status.retry()) {
                    Serializable ex = ColumnTracker.this.m_retries;
                    Integer n = ColumnTracker.this.m_retries = ColumnTracker.this.m_retries - 1;
                    if (ex <= 0) {
                        ex = new ErrorStatusException(status, "Non-fatal error met maximum number of retries. Aborting!");
                        ColumnTracker.this.reportFatalErr((ErrorStatusException)ex);
                        throw ex;
                    }
                } else {
                    ColumnTracker.this.m_retries = ColumnTracker.this.getMaxRetries();
                }
                return status.retry();
            }
        };
        return rp;
    }

    public int getMaxRepetitions() {
        return this.m_maxRepetitions;
    }

    @Override
    public void setMaxRepetitions(int maxRepetitions) {
        this.m_maxRepetitions = maxRepetitions;
    }

    public int getMaxRetries() {
        return this.m_maxRetries;
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        LOG.debug("setMaxRetries({})", (Object)maxRetries);
        this.m_maxRetries = maxRetries;
    }

    protected void receivedEndOfMib() {
        this.setFinished(true);
    }

    protected void errorOccurred() {
        this.setFinished(true);
    }

    public SnmpInstId getLastInstance() {
        if (this.m_base.isPrefixOf(this.m_last) && !this.m_base.equals(this.m_last)) {
            return this.m_last.getInstance(this.m_base);
        }
        return null;
    }

    @Override
    public List<WalkRequest> getWalkRequests() {
        WalkRequest walkRequest = new WalkRequest(this.m_base);
        walkRequest.setMaxRepetitions(this.m_maxRepetitions);
        return Collections.singletonList(walkRequest);
    }

    @Override
    public void handleWalkResponses(List<WalkResponse> responses) {
        responses.stream().flatMap(res -> res.getResults().stream()).filter(res -> {
            SnmpObjId responseOid = SnmpObjId.get(res.getBase(), res.getInstance());
            return this.m_base.isPrefixOf(responseOid) && !this.m_base.equals(responseOid);
        }).forEach(res -> this.storeResult((SnmpResult)res));
        this.setFinished(true);
    }
}

