/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.trapd.TrapdConfiguration;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.trapd.TrapReceiverImpl;

public class TrapdConfigBean
implements TrapdConfig,
Serializable {
    private static final long serialVersionUID = -4406324301602556539L;
    private String m_snmpTrapAddress;
    private int m_snmpTrapPort;
    private boolean m_newSuspectOnTrap;
    private final List<SnmpV3User> m_snmpV3Users = Collections.synchronizedList(new ArrayList());

    public void setSnmpTrapAddress(String snmpTrapAddress) {
        this.m_snmpTrapAddress = snmpTrapAddress;
    }

    public void setSnmpTrapPort(int snmpTrapPort) {
        this.m_snmpTrapPort = snmpTrapPort;
    }

    public void setNewSuspectOnTrap(boolean newSuspectOnTrap) {
        this.m_newSuspectOnTrap = newSuspectOnTrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSnmpV3Users(List<SnmpV3User> snmpV3Users) {
        List<SnmpV3User> list = this.m_snmpV3Users;
        synchronized (list) {
            this.m_snmpV3Users.clear();
            this.m_snmpV3Users.addAll(snmpV3Users);
        }
    }

    public String getSnmpTrapAddress() {
        return this.m_snmpTrapAddress;
    }

    public int getSnmpTrapPort() {
        return this.m_snmpTrapPort;
    }

    public boolean getNewSuspectOnTrap() {
        return this.m_newSuspectOnTrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SnmpV3User> getSnmpV3Users() {
        List<SnmpV3User> list = this.m_snmpV3Users;
        synchronized (list) {
            return Collections.unmodifiableList(this.m_snmpV3Users);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate(TrapdConfiguration config) {
        this.m_snmpTrapAddress = config.getSnmpTrapAddress();
        this.m_snmpTrapPort = config.getSnmpTrapPort();
        List<SnmpV3User> list = this.m_snmpV3Users;
        synchronized (list) {
            this.m_snmpV3Users.clear();
            if (config.getSnmpv3UserCollection() != null) {
                this.m_snmpV3Users.addAll(config.getSnmpv3UserCollection().stream().map(TrapReceiverImpl::toSnmpV3User).collect(Collectors.toList()));
            }
        }
    }
}

