/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.Rejectable;

@XmlType
@XmlEnum(value=String.class)
public enum ThreadPoolRejectedPolicy {
    Abort,
    CallerRuns,
    DiscardOldest,
    Discard;


    public RejectedExecutionHandler asRejectedExecutionHandler() {
        if (this == Abort) {
            return new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    if (r instanceof Rejectable) {
                        ((Rejectable)((Object)r)).reject();
                    }
                }

                public String toString() {
                    return "Abort";
                }
            };
        }
        if (this == CallerRuns) {
            return new ThreadPoolExecutor.CallerRunsPolicy(){

                public String toString() {
                    return "CallerRuns";
                }
            };
        }
        if (this == DiscardOldest) {
            return new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    if (!executor.isShutdown()) {
                        Runnable rejected = (Runnable)executor.getQueue().poll();
                        if (rejected instanceof Rejectable) {
                            ((Rejectable)((Object)rejected)).reject();
                        }
                        executor.execute(r);
                    }
                }

                public String toString() {
                    return "DiscardOldest";
                }
            };
        }
        if (this == Discard) {
            return new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    if (r instanceof Rejectable) {
                        ((Rejectable)((Object)r)).reject();
                    }
                }

                public String toString() {
                    return "Discard";
                }
            };
        }
        throw new IllegalArgumentException("Unknown ThreadPoolRejectedPolicy: " + (Object)((Object)this));
    }
}

