/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.trapd.Snmpv3User;
import org.opennms.netmgt.config.trapd.TrapdConfiguration;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class TrapdConfigFactory
implements TrapdConfig {
    private static TrapdConfig m_singleton = null;
    private TrapdConfiguration m_config;
    private static boolean m_loaded = false;

    private TrapdConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        this.m_config = (TrapdConfiguration)CastorUtils.unmarshal(TrapdConfiguration.class, (Resource)new FileSystemResource(configFile));
    }

    public TrapdConfigFactory(InputStream stream) throws MarshalException, ValidationException {
        this.m_config = (TrapdConfiguration)CastorUtils.unmarshal(TrapdConfiguration.class, (InputStream)stream);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.TRAPD_CONFIG_FILE_NAME);
        m_singleton = new TrapdConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        TrapdConfigFactory.init();
    }

    public static synchronized TrapdConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(TrapdConfig config) {
        m_singleton = config;
        m_loaded = true;
    }

    @Override
    public synchronized String getSnmpTrapAddress() {
        return this.m_config.getSnmpTrapAddress();
    }

    @Override
    public synchronized int getSnmpTrapPort() {
        return this.m_config.getSnmpTrapPort();
    }

    @Override
    public synchronized boolean getNewSuspectOnTrap() {
        return this.m_config.getNewSuspectOnTrap();
    }

    @Override
    public synchronized List<SnmpV3User> getSnmpV3Users() {
        ArrayList<SnmpV3User> snmpUsers = new ArrayList<SnmpV3User>();
        for (Snmpv3User user : this.m_config.getSnmpv3UserCollection()) {
            snmpUsers.add(new SnmpV3User(user.getEngineId(), user.getSecurityName(), user.getAuthProtocol(), user.getAuthPassphrase(), user.getPrivacyProtocol(), user.getPrivacyPassphrase()));
        }
        return snmpUsers;
    }

    @Override
    public void onUpdate(TrapdConfiguration config) {
        this.m_config.setSnmpTrapAddress(config.getSnmpTrapAddress());
        this.m_config.setSnmpTrapPort(config.getSnmpTrapPort());
        this.m_config.setSnmpv3User(config.getSnmpv3User());
    }
}

