/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.net.InetAddress;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.icmp.proxy.PingRequest;

@XmlRootElement(name="ping-request")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PingRequestDTO
implements RpcRequest {
    @XmlElement(name="address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress inetAddress;
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="retries")
    private int retries;
    @XmlAttribute(name="timeout")
    private long timeout;
    @XmlElement(name="packet-size")
    private int packetSize;

    public String getLocation() {
        return this.location;
    }

    public Long getTimeToLiveMs() {
        return (long)(1 + this.retries) * this.timeout * 2L;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setTimeout(long timeoutInMs) {
        this.timeout = timeoutInMs;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getRetries() {
        return this.retries;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public PingRequest toPingRequest() {
        PingRequest pingRequest = new PingRequest();
        pingRequest.setInetAddress(this.inetAddress);
        pingRequest.setTimeout(this.timeout);
        pingRequest.setRetries(this.retries);
        pingRequest.setPacketSize(this.packetSize);
        return pingRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PingRequestDTO that = (PingRequestDTO)o;
        return Objects.equals(this.retries, that.retries) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.packetSize, that.packetSize) && Objects.equals(this.inetAddress, that.inetAddress) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.inetAddress, this.location, this.retries, this.timeout, this.packetSize);
    }
}

