/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.opennmsDataSources.ConnectionPool;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceConfigurationFactory.class);
    private final DataSourceConfiguration m_dsc;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSourceConfigurationFactory(File fileName) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
            this.m_dsc = (DataSourceConfiguration)CastorUtils.unmarshal(DataSourceConfiguration.class, (InputStream)is);
        }
        catch (MarshalException e) {
            try {
                throw new IllegalArgumentException("Could not unmarshal " + DataSourceConfiguration.class.getName(), e);
                catch (ValidationException e2) {
                    throw new IllegalArgumentException("Could not unmarshal " + DataSourceConfiguration.class.getName(), e2);
                }
                catch (FileNotFoundException e3) {
                    throw new IllegalArgumentException("Could not unmarshal " + DataSourceConfiguration.class.getName(), e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public DataSourceConfigurationFactory(String fileName) {
        this(new File(fileName));
    }

    public DataSourceConfigurationFactory(InputStream fileInputStream) {
        try {
            this.m_dsc = (DataSourceConfiguration)CastorUtils.unmarshal(DataSourceConfiguration.class, (InputStream)fileInputStream);
        }
        catch (MarshalException e) {
            throw new IllegalArgumentException("Could not unmarshal " + DataSourceConfiguration.class.getName(), e);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException("Could not unmarshal " + DataSourceConfiguration.class.getName(), e);
        }
    }

    public ConnectionPool getConnectionPool() {
        return this.m_dsc.getConnectionPool();
    }

    public JdbcDataSource getJdbcDataSource(String name) {
        for (JdbcDataSource ds : this.m_dsc.getJdbcDataSource()) {
            if (!ds.getName().equals(name)) continue;
            return ds;
        }
        return null;
    }
}

