/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.karaf.commands.CamelCommandSupport;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.util.MessageDump;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(scope="camel", name="backlog-tracer-dump", description="Dumps traced messages from the Backlog tracer")
public class BacklogTracerDump
extends CamelCommandSupport {
    @Argument(index=0, name="context", description="The name of the Camel context.", required=true, multiValued=false)
    String context;
    @Argument(index=1, name="pattern", description="To dump trace messages only for nodes or routes matching the given pattern (default is all)", required=false, multiValued=false)
    String pattern;
    @Option(name="--format", aliases={"-f"}, description="Format to use with the dump action (text or xml)", required=false, multiValued=false, valueToShowInHelp="text")
    String format;
    @Option(name="--bodySize", aliases={"-bs"}, description="To limit the body size when using text format", required=false, multiValued=false)
    Integer bodySize;

    protected Object doExecute() throws Exception {
        CamelContext camel = this.camelController.getCamelContext(this.context);
        if (camel == null) {
            System.err.println("CamelContext " + this.context + " not found.");
            return null;
        }
        BacklogTracer backlogTracer = BacklogTracer.getBacklogTracer((CamelContext)camel);
        if (backlogTracer == null) {
            backlogTracer = (BacklogTracer)camel.getDefaultBacklogTracer();
        }
        if (this.format == null || "text".equals(this.format)) {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MessageDump.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            List events = this.pattern != null ? backlogTracer.dumpTracedMessages(this.pattern) : backlogTracer.dumpAllTracedMessages();
            for (BacklogTracerEventMessage event : events) {
                MessageDump msg = (MessageDump)unmarshaller.unmarshal((Reader)new StringReader(event.getMessageAsXml()));
                String breadcrumb = BacklogTracerDump.getBreadcrumbId(msg.getHeaders());
                System.out.println("#" + event.getUid() + "\tTimestamp:\t" + sdf.format(event.getTimestamp()));
                if (breadcrumb != null) {
                    System.out.println("Breadcrumb: " + breadcrumb);
                }
                System.out.println("ExchangeId: " + event.getExchangeId());
                if (event.getToNode() != null) {
                    System.out.println("Route: " + event.getRouteId() + "\t--> " + event.getToNode());
                } else {
                    System.out.println("Route: " + event.getRouteId());
                }
                String body = msg.getBody().getValue();
                if (this.bodySize != null && this.bodySize > 0 && body.length() > this.bodySize) {
                    body = body.substring(0, this.bodySize);
                }
                System.out.println(body);
                System.out.println("");
            }
        } else if ("xml".equals(this.format)) {
            if (this.pattern != null) {
                System.out.println("BacklogTracer messages:\n" + backlogTracer.dumpTracedMessages(this.pattern));
            } else {
                System.out.println("BacklogTracer messages:\n" + backlogTracer.dumpAllTracedMessagesAsXml());
            }
            return null;
        }
        return null;
    }

    private static String getBreadcrumbId(List<MessageDump.Header> headers) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        for (MessageDump.Header header : headers) {
            if (!header.getKey().equals("breadcrumbId")) continue;
            return header.getValue();
        }
        return null;
    }
}

