/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.PingObject;
import org.jinterop.dcom.transport.JIComTransportFactory;
import rpc.Stub;
import rpc.TransportFactory;

final class JIComOxidStub
extends Stub {
    private static Properties defaults = new Properties();

    static {
        ((Hashtable)defaults).put("rpc.ntlm.lanManagerKey", "false");
        ((Hashtable)defaults).put("rpc.ntlm.sign", "false");
        ((Hashtable)defaults).put("rpc.ntlm.seal", "false");
        ((Hashtable)defaults).put("rpc.ntlm.keyExchange", "false");
        ((Hashtable)defaults).put("rpc.connectionContext", "rpc.security.ntlm.NtlmConnectionContext");
    }

    protected String getSyntax() {
        return "99fcfec4-5260-101b-bbcb-00aa0021347a:0.0";
    }

    public JIComOxidStub(String address, String domain, String username, String password) {
        super.setTransportFactory((TransportFactory)JIComTransportFactory.getSingleTon());
        super.setProperties(new Properties(defaults));
        super.getProperties().setProperty("rpc.security.username", username);
        super.getProperties().setProperty("rpc.security.password", password);
        super.getProperties().setProperty("rpc.ntlm.domain", domain);
        super.setAddress("ncacn_ip_tcp:" + address + "[135]");
    }

    public byte[] call(boolean isSimplePing, byte[] setId, ArrayList listOfAdds, ArrayList listOfDels, int seqNum) {
        PingObject pingObject = new PingObject();
        pingObject.setId = setId;
        pingObject.listOfAdds = listOfAdds;
        pingObject.listOfDels = listOfDels;
        pingObject.seqNum = seqNum;
        pingObject.opnum = isSimplePing ? 1 : 2;
        try {
            this.call(2, pingObject);
        }
        catch (IOException e) {
            JISystem.getLogger().throwing("JIComOxidStub", "call", e);
        }
        return pingObject.setId;
    }

    public void close() {
        try {
            this.detach();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

