/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.ServiceConfigFactory;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.PingerFactoryImpl;
import org.opennms.netmgt.vmmgr.Invoker;
import org.opennms.netmgt.vmmgr.InvokerResult;
import org.opennms.netmgt.vmmgr.InvokerService;
import org.opennms.netmgt.vmmgr.ManagerMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manager
implements ManagerMBean {
    private static final Logger LOG = LoggerFactory.getLogger(Manager.class);
    private static final String LOG4J_CATEGORY = "manager";
    private static final String m_osName = System.getProperty("os.name") == null ? "" : System.getProperty("os.name").toLowerCase();
    private static long startTime = System.currentTimeMillis();

    @Override
    public void stop() {
        this.setLogPrefix();
        for (MBeanServer server : this.getMBeanServers()) {
            this.stop(server);
        }
    }

    private void stop(MBeanServer server) {
        LOG.debug("Beginning shutdown");
        Invoker invoker = new Invoker();
        invoker.setServer(server);
        invoker.setAtType(InvokeAtType.STOP);
        invoker.setReverse(true);
        invoker.setFailFast(false);
        List<InvokerService> services = InvokerService.createServiceList(new ServiceConfigFactory().getServices());
        invoker.setServices(services);
        invoker.getObjectInstances();
        invoker.invokeMethods();
        LOG.debug("Shutdown complete");
    }

    @Override
    public List<String> status() {
        this.setLogPrefix();
        ArrayList<String> result = new ArrayList<String>();
        for (MBeanServer server : this.getMBeanServers()) {
            result.addAll(this.status(server));
        }
        return result;
    }

    private List<String> status(MBeanServer server) {
        LOG.debug("Beginning status check");
        Invoker invoker = new Invoker();
        invoker.setServer(server);
        invoker.setAtType(InvokeAtType.STATUS);
        invoker.setFailFast(false);
        List<InvokerService> services = InvokerService.createServiceList(new ServiceConfigFactory().getServices());
        invoker.setServices(services);
        invoker.getObjectInstances();
        List<InvokerResult> results = invoker.invokeMethods();
        ArrayList<String> statusInfo = new ArrayList<String>(results.size());
        for (InvokerResult invokerResult : results) {
            if (invokerResult.getThrowable() == null) {
                statusInfo.add("Status: " + invokerResult.getMbean().getObjectName() + " = " + invokerResult.getResult().toString());
                continue;
            }
            statusInfo.add("Status: " + invokerResult.getMbean().getObjectName() + " = STATUS_CHECK_ERROR");
        }
        LOG.debug("Status check complete");
        return statusInfo;
    }

    @Override
    public void doSystemExit() {
        this.setLogPrefix();
        LOG.debug("doSystemExit called");
        if (LOG.isDebugEnabled()) {
            this.dumpThreads();
            Runtime r = Runtime.getRuntime();
            LOG.debug("memory usage (free/used/total/max allowed): {}/{}/{}/{}", new Object[]{r.freeMemory(), r.totalMemory() - r.freeMemory(), r.totalMemory(), r.maxMemory() == Long.MAX_VALUE ? "infinite" : Long.valueOf(r.maxMemory())});
        }
        LOG.info("calling System.exit(0)");
        this.shutdownLogging();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                System.exit(0);
            }
        }, 500L);
    }

    @Override
    public void dumpThreads() {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        int daemons = 0;
        for (Thread t : threads.keySet()) {
            if (!t.isDaemon()) continue;
            ++daemons;
        }
        LOG.debug("Thread dump of {} threads ({} daemons):", (Object)threads.size(), (Object)daemons);
        TreeMap<Thread, StackTraceElement[]> sortedThreads = new TreeMap<Thread, StackTraceElement[]>(new Comparator<Thread>(){

            @Override
            public int compare(Thread t1, Thread t2) {
                return new Long(t1.getId()).compareTo(new Long(t2.getId()));
            }
        });
        sortedThreads.putAll(threads);
        for (Map.Entry entry : sortedThreads.entrySet()) {
            Thread thread = (Thread)entry.getKey();
            LOG.debug("Thread {}{}: {} (state: {})", new Object[]{thread.getId(), thread.isDaemon() ? " (daemon)" : "", thread, thread.getState()});
            for (StackTraceElement e : (StackTraceElement[])entry.getValue()) {
                LOG.debug("\t{}", (Object)e);
            }
        }
        LOG.debug("Thread dump completed.");
    }

    private void shutdownLogging() {
    }

    @Override
    public void doTestLoadLibraries() {
        this.setLogPrefix();
        this.testPinger();
        this.testGetLocalHost();
    }

    private void testGetLocalHost() {
        try {
            InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new UndeclaredThrowableException(e, "Could not lookup the host name for the local host machine: " + e);
        }
    }

    private void testPinger() {
        Pinger pinger = new PingerFactoryImpl().getInstance();
        boolean hasV4 = pinger.isV4Available();
        boolean hasV6 = pinger.isV6Available();
        LOG.info("Using ICMP implementation: {}", (Object)pinger.getClass().getName());
        LOG.info("IPv4 ICMP available? {}", (Object)hasV4);
        LOG.info("IPv6 ICMP available? {}", (Object)hasV6);
        if (!hasV4) {
            try {
                pinger.initialize4();
                hasV4 = true;
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize IPv4 stack.", (Throwable)e);
            }
        }
        if (!hasV6) {
            try {
                pinger.initialize6();
                hasV6 = true;
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize IPv6 stack.", (Throwable)e);
            }
        }
        if (!hasV4 && !hasV6) {
            this.throwPingError("Neither IPv4 nor IPv6 are avaialable.  Bailing.");
        }
        String requireV4String = System.getProperty("org.opennms.netmgt.icmp.requireV4");
        String requireV6String = System.getProperty("org.opennms.netmgt.icmp.requireV6");
        if ("true".equalsIgnoreCase(requireV4String) && !hasV4) {
            this.throwPingError("org.opennms.netmgt.icmp.requireV4 is true, but IPv4 ICMP could not be initialized.");
        }
        if ("true".equalsIgnoreCase(requireV6String) && !hasV6) {
            this.throwPingError("org.opennms.netmgt.icmp.requireV6 is true, but IPv6 ICMP could not be initialized.");
        }
    }

    private void throwPingError(String message) throws IllegalStateException {
        String errorMessage = message;
        if (m_osName.contains("win")) {
            errorMessage = errorMessage + " On Windows, you can see this error if you are not running OpenNMS in an Administrator shell.";
        }
        throw new IllegalStateException(errorMessage);
    }

    private void setLogPrefix() {
        Logging.putPrefix((String)LOG4J_CATEGORY);
    }

    private List<MBeanServer> getMBeanServers() {
        return MBeanServerFactory.findMBeanServer(null);
    }

    @Override
    public Long getUptime() {
        return System.currentTimeMillis() - startTime;
    }
}

