/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.rt;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.protocols.rt.Messenger;
import org.opennms.protocols.rt.ReplyHandler;
import org.opennms.protocols.rt.Request;
import org.opennms.protocols.rt.RequestLocator;
import org.opennms.protocols.rt.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestTracker<ReqT extends Request<?, ReqT, ReplyT>, ReplyT extends Response>
implements ReplyHandler<ReplyT> {
    private static final Logger s_log = LoggerFactory.getLogger(RequestTracker.class);
    private RequestLocator<ReqT, ReplyT> m_requestLocator;
    private Messenger<ReqT, ReplyT> m_messenger;
    private final BlockingQueue<Callable<Void>> m_callbackQueue;
    private DelayQueue<ReqT> m_timeoutQueue;
    private Thread m_callbackProcessor;
    private Thread m_timeoutProcessor;
    private static final int NEW = 0;
    private static final int STARTING = 1;
    private static final int STARTED = 2;
    private AtomicInteger m_state = new AtomicInteger(0);

    public RequestTracker(String name, Messenger<ReqT, ReplyT> messenger, RequestLocator<ReqT, ReplyT> requestLocator) throws IOException {
        this.m_requestLocator = requestLocator;
        this.m_callbackQueue = new LinkedBlockingQueue<Callable<Void>>();
        this.m_timeoutQueue = new DelayQueue();
        this.m_callbackProcessor = new Thread(name + "-Callback-Processor"){

            public void run() {
                try {
                    RequestTracker.this.processCallbacks();
                }
                catch (InterruptedException e) {
                    s_log.error("Thread {} interrupted!", (Object)this);
                }
                catch (Throwable t) {
                    s_log.error("Unexpected exception on Thread " + this + "!", t);
                }
            }
        };
        this.m_timeoutProcessor = new Thread(name + "-Timeout-Processor"){

            public void run() {
                try {
                    RequestTracker.this.processTimeouts();
                }
                catch (InterruptedException e) {
                    s_log.error("Thread {} interrupted!", (Object)this);
                }
                catch (Throwable t) {
                    s_log.error("Unexpected exception on Thread " + this + "!", t);
                }
            }
        };
        this.m_messenger = messenger;
    }

    public synchronized void start() {
        boolean startNeeded = this.m_state.compareAndSet(0, 1);
        if (startNeeded) {
            this.m_messenger.start(this);
            this.m_timeoutProcessor.start();
            this.m_callbackProcessor.start();
            this.m_state.set(2);
        }
    }

    public void assertStarted() {
        boolean started;
        boolean bl = started = this.m_state.get() == 2;
        if (!started) {
            throw new IllegalStateException("RequestTracker not started!");
        }
    }

    public void sendRequest(ReqT request) throws Exception {
        this.assertStarted();
        if (!this.m_requestLocator.trackRequest(request)) {
            return;
        }
        this.m_messenger.sendRequest(request);
        s_log.debug("Scheding timeout for request to {} in {} ms", request, (Object)request.getDelay(TimeUnit.MILLISECONDS));
        this.m_timeoutQueue.offer(request);
    }

    @Override
    public void handleReply(ReplyT reply) {
        this.m_callbackQueue.add(new ReplyCallback<ReqT, ReplyT>(this.m_requestLocator, reply));
    }

    private void processTimeouts() throws InterruptedException {
        while (true) {
            Request timedOutRequest;
            if ((timedOutRequest = (Request)this.m_timeoutQueue.take()).isProcessed()) {
                continue;
            }
            this.m_callbackQueue.add(new TimedOutRequestCallback<Request, ReplyT>(this, this.m_requestLocator, timedOutRequest));
        }
    }

    private void processCallbacks() throws InterruptedException {
        while (true) {
            Callable<Void> callback = this.m_callbackQueue.take();
            try {
                callback.call();
                continue;
            }
            catch (Exception e) {
                s_log.error("Failed to issue callback {}.", callback, (Object)e);
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimedOutRequestCallback<ReqT extends Request<?, ReqT, ?>, ReplyT>
    implements Callable<Void> {
        private final RequestTracker<ReqT, ?> m_tracker;
        private final RequestLocator<ReqT, ReplyT> m_requestLocator;
        private final ReqT m_timedOutRequest;

        public TimedOutRequestCallback(RequestTracker<ReqT, ?> tracker, RequestLocator<ReqT, ReplyT> requestLocator, ReqT timedOutRequest) {
            this.m_tracker = tracker;
            this.m_requestLocator = requestLocator;
            this.m_timedOutRequest = timedOutRequest;
        }

        @Override
        public Void call() throws Exception {
            if (this.m_timedOutRequest.isProcessed()) {
                return null;
            }
            s_log.debug("Processing a possibly timed-out request: {}", this.m_timedOutRequest);
            Request pendingRequest = (Request)this.m_requestLocator.requestTimedOut(this.m_timedOutRequest);
            if (pendingRequest == this.m_timedOutRequest) {
                Request retry = null;
                try {
                    s_log.debug("Processing timeout for: {}", this.m_timedOutRequest);
                    retry = (Request)this.m_timedOutRequest.processTimeout();
                }
                catch (Throwable t) {
                    s_log.error("Unexpected error processingTimout to request: {}", this.m_timedOutRequest, (Object)t);
                    retry = null;
                }
                if (retry != null) {
                    try {
                        this.m_tracker.sendRequest(retry);
                    }
                    catch (Exception e) {
                        retry.processError(e);
                    }
                }
            } else if (pendingRequest != null) {
                String msg = String.format("A pending request %s with the same id exists but is not the timeout request %s from the queue!", pendingRequest, this.m_timedOutRequest);
                s_log.error(msg);
                this.m_timedOutRequest.processError(new IllegalStateException(msg));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReplyCallback<ReqT extends Request<?, ?, ReplyT>, ReplyT>
    implements Callable<Void> {
        private final RequestLocator<ReqT, ReplyT> m_requestLocator;
        private final ReplyT m_reply;

        public ReplyCallback(RequestLocator<ReqT, ReplyT> requestLocator, ReplyT reply) {
            this.m_requestLocator = requestLocator;
            this.m_reply = reply;
        }

        @Override
        public Void call() throws Exception {
            s_log.debug("Processing reply: {}", this.m_reply);
            ReqT request = this.locateMatchingRequest(this.m_reply);
            if (request != null) {
                boolean isComplete;
                try {
                    s_log.debug("Processing reply {} for request {}", this.m_reply, request);
                    isComplete = request.processResponse(this.m_reply);
                }
                catch (Throwable t) {
                    s_log.error("Unexpected error processingResponse to request: {}, reply is {}", new Object[]{request, this.m_reply, t});
                    isComplete = true;
                }
                if (isComplete) {
                    this.m_requestLocator.requestComplete(request);
                }
            } else {
                s_log.info("No request found for reply {}", this.m_reply);
            }
            return null;
        }

        private ReqT locateMatchingRequest(ReplyT reply) {
            try {
                return (ReqT)((Request)this.m_requestLocator.locateMatchingRequest(reply));
            }
            catch (Throwable t) {
                s_log.error("Unexpected error locating response to request " + reply + ". Discarding response!", t);
                return null;
            }
        }
    }
}

