/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.netmgt.icmp.proxy.PingRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingSummary;
import org.opennms.netmgt.icmp.proxy.strategy.MultiplePingExecutionStrategy;
import org.opennms.netmgt.icmp.proxy.strategy.SinglePingExecutionStrategy;

public class PingRequestBuilderImpl
implements PingRequestBuilder {
    protected final RpcClient<PingRequestDTO, PingResponseDTO> client;
    protected long timeout = 800L;
    protected int packetSize = 64;
    protected int retries = 2;
    private int numberOfRequests = 1;
    protected InetAddress inetAddress;
    protected String location;
    private PingRequestBuilder.Callback callback;

    public PingRequestBuilderImpl(RpcClient<PingRequestDTO, PingResponseDTO> client) {
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public PingRequestBuilder withTimeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"timeout must be > 0");
        Objects.requireNonNull(unit);
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this;
    }

    @Override
    public PingRequestBuilder withPacketSize(int packetSize) {
        Preconditions.checkArgument((packetSize > 0 ? 1 : 0) != 0, (Object)"packetSize must be > 0");
        this.packetSize = packetSize;
        return this;
    }

    @Override
    public PingRequestBuilder withRetries(int retries) {
        Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0, (Object)"retries must be >= 0");
        this.retries = retries;
        return this;
    }

    @Override
    public PingRequestBuilder withInetAddress(InetAddress inetAddress) {
        this.inetAddress = Objects.requireNonNull(inetAddress);
        return this;
    }

    @Override
    public PingRequestBuilder withLocation(String location) {
        this.location = Objects.requireNonNull(location);
        return this;
    }

    @Override
    public PingRequestBuilder withNumberOfRequests(int numberOfRequests) {
        Preconditions.checkArgument((numberOfRequests >= 1 ? 1 : 0) != 0, (Object)"number of requests must be >= 1");
        this.numberOfRequests = numberOfRequests;
        return this;
    }

    @Override
    public PingRequestBuilder withProgressCallback(PingRequestBuilder.Callback callback) {
        this.callback = Objects.requireNonNull(callback);
        return this;
    }

    @Override
    public CompletableFuture<PingSummary> execute() {
        PingRequestDTO requestDTO = new PingRequestDTO();
        requestDTO.setInetAddress(this.inetAddress);
        requestDTO.setPacketSize(this.packetSize);
        requestDTO.setTimeout(this.timeout);
        requestDTO.setRetries(this.retries);
        requestDTO.setLocation(this.location);
        if (this.numberOfRequests > 1) {
            return new MultiplePingExecutionStrategy(this.client, this.numberOfRequests, this.callback).execute(requestDTO);
        }
        return new SinglePingExecutionStrategy(this.client).execute(requestDTO);
    }
}

