/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import java.io.StringWriter;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.opennms.core.xml.CastorUtils;
import org.opennms.core.xml.JaxbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbClassXmlAdapter
extends XmlAdapter<String, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbClassXmlAdapter.class);

    public JaxbClassXmlAdapter() {
        LOG.info("Initializing JaxbClassXmlAdapter.");
    }

    public Object unmarshal(String xmlText) throws Exception {
        LOG.trace("unmarshal: xml = {}", (Object)xmlText);
        if (xmlText == null || xmlText.isEmpty()) {
            return null;
        }
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public String marshal(Object obj) throws Exception {
        LOG.trace("marshal: object = {}", obj);
        if (obj == null) {
            return "";
        }
        try {
            String text = JaxbUtils.marshal(obj);
            LOG.debug("marshal: text = {}", (Object)text);
            return text == null ? "" : text;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            CastorUtils.marshalWithTranslatedExceptions(obj, sw);
            String text = sw.toString();
            LOG.debug("marshal: text = {}", (Object)text);
            return text == null ? "" : text;
        }
    }
}

