/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$AddPartitionsListener$;
import kafka.controller.PartitionStateMachine$DeleteTopicsListener$;
import kafka.controller.PartitionStateMachine$TopicChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r]a\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtDC\u0001\u000f\u001e!\t1\u0002\u0001C\u0003\u00043\u0001\u0007Q\u0003C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001\"!\t1\"%\u0003\u0002$\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r\u0015\u0002\u0001\u0015!\u0003\"\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0006\u0005\u0002\nU%\u00111F\u0003\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%\u0011&A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003!Q8n\u00117jK:$X#A\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014\u0001\u0003>lG2LWM\u001c;\u000b\u0005Y:\u0014AB%1\u0013R,7MC\u00019\u0003\ry'oZ\u0005\u0003uM\u0012\u0001BW6DY&,g\u000e\u001e\u0005\u0007y\u0001\u0001\u000b\u0011B\u0019\u0002\u0013i\\7\t\\5f]R\u0004\u0003b\u0002 \u0001\u0001\u0004%\taP\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f+\u0005\u0001\u0005\u0003B!G\u0011:k\u0011A\u0011\u0006\u0003\u0007\u0012\u000bq!\\;uC\ndWM\u0003\u0002F\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d\u0013%aA'baB\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nB\u0001\u0007G>lWn\u001c8\n\u00055S%!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011acT\u0005\u0003!\n\u0011a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\rC\u0004S\u0001\u0001\u0007I\u0011A*\u0002%A\f'\u000f^5uS>t7\u000b^1uK~#S-\u001d\u000b\u0003)^\u0003\"!C+\n\u0005YS!\u0001B+oSRDq\u0001W)\u0002\u0002\u0003\u0007\u0001)A\u0002yIEBaA\u0017\u0001!B\u0013\u0001\u0015a\u00049beRLG/[8o'R\fG/\u001a\u0011\t\u000fq\u0003!\u0019!C\u0001;\u0006\u0011\"M]8lKJ\u0014V-];fgR\u0014\u0015\r^2i+\u0005q\u0006C\u0001\f`\u0013\t\u0001'A\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\t\r\t\u0004\u0001\u0015!\u0003_\u0003M\u0011'o\\6feJ+\u0017/^3ti\n\u000bGo\u00195!\u0011\u001d!\u0007A1A\u0005\n\u0015\f!\u0002[1t'R\f'\u000f^3e+\u00051\u0007CA4q\u001b\u0005A'BA5k\u0003\u0019\tGo\\7jG*\u00111\u000e\\\u0001\u000bG>t7-\u001e:sK:$(BA7o\u0003\u0011)H/\u001b7\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001b\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\rM\u0004\u0001\u0015!\u0003g\u0003-A\u0017m]*uCJ$X\r\u001a\u0011\t\u000fU\u0004!\u0019!C\u0005m\u0006Ybn\\(q!\u0006\u0014H/\u001b;j_:dU-\u00193feN+G.Z2u_J,\u0012a\u001e\t\u0003-aL!!\u001f\u0002\u0003%9{w\n\u001d'fC\u0012,'oU3mK\u000e$xN\u001d\u0005\u0007w\u0002\u0001\u000b\u0011B<\u000299|w\n\u001d)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8sA!9Q\u0010\u0001b\u0001\n\u0013q\u0018!E:uCR,7\t[1oO\u0016dunZ4feV\tq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u000b1|w\r\u000e6\u000b\u0007\u0005%q'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u001b\t\u0019A\u0001\u0004M_\u001e<WM\u001d\u0005\b\u0003#\u0001\u0001\u0015!\u0003\u0000\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\t\u0013\u0005U\u0001\u00011A\u0005\n\u0005]\u0011a\u0005;pa&\u001c7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014XCAA\r!\u0011\tY\"!\b\u000e\u0003\u00011a!a\b\u0001\u0001\u0005\u0005\"a\u0005+pa&\u001c7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u00148cBA\u000f\u0003G\tyC\u0004\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u00068\u0002\t1\fgnZ\u0005\u0005\u0003[\t9C\u0001\u0004PE*,7\r\u001e\t\u0004e\u0005E\u0012bAA\u001ag\t\u0001\u0012JW6DQ&dG\rT5ti\u0016tWM\u001d\u0005\b5\u0005uA\u0011AA\u001c)\t\tI\u0002\u0003\u0005\u0002<\u0005uA\u0011AA\u001f\u0003EA\u0017M\u001c3mK\u000eC\u0017\u000e\u001c3DQ\u0006tw-\u001a\u000b\u0006)\u0006}\u0012\u0011\u000b\u0005\t\u0003\u0003\nI\u00041\u0001\u0002D\u0005Q\u0001/\u0019:f]R\u0004\u0016\r\u001e5\u0011\t\u0005\u0015\u00131\n\b\u0004\u0013\u0005\u001d\u0013bAA%\u0015\u00051\u0001K]3eK\u001aLA!!\u0014\u0002P\t11\u000b\u001e:j]\u001eT1!!\u0013\u000b\u0011!\t\u0019&!\u000fA\u0002\u0005U\u0013\u0001C2iS2$'/\u001a8\u0011\r\u0005]\u0013\u0011LA\"\u001b\u0005a\u0017bAA.Y\n!A*[:uQ\u0019\tI$a\u0018\u0002\u0004B)\u0011\"!\u0019\u0002f%\u0019\u00111\r\u0006\u0003\rQD'o\\<t!\u0011\t9'!\u001b\r\u0001\u00119\u00111\u000e\u0001C\u0002\u00055$!\u0001+\u0012\t\u0005=\u0014Q\u000f\t\u0004\u0013\u0005E\u0014bAA:\u0015\t9aj\u001c;iS:<\u0007\u0003BA<\u0003{r1!CA=\u0013\r\tYHC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty(!!\u0003\u0013QC'o\\<bE2,'bAA>\u0015\r\u0012\u0011Q\u0011\t\u0005\u0003\u000f\u000b\u0019J\u0004\u0003\u0002\n\u0006ed\u0002BAF\u0003#k!!!$\u000b\u0007\u0005=e!\u0001\u0004=e>|GOP\u0005\u0002\u0017%!\u0011QSAA\u0005%)\u0005pY3qi&|g\u000eC\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0003\u0002\u001c\u00069Bo\u001c9jG\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe~#S-\u001d\u000b\u0004)\u0006u\u0005\"\u0003-\u0002\u0018\u0006\u0005\t\u0019AA\r\u0011!\t\t\u000b\u0001Q!\n\u0005e\u0011\u0001\u0006;pa&\u001c7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\b\u0005C\u0005\u0002&\u0002\u0001\r\u0011\"\u0003\u0002(\u0006!B-\u001a7fi\u0016$v\u000e]5dg2K7\u000f^3oKJ,\"!!+\u0011\t\u0005m\u00111\u0016\u0004\u0007\u0003[\u0003\u0001!a,\u0003)\u0011+G.\u001a;f)>\u0004\u0018nY:MSN$XM\\3s'\u001d\tY+a\t\u000209AqAGAV\t\u0003\t\u0019\f\u0006\u0002\u0002*\"Aq&a+C\u0002\u0013\u0005\u0001\u0007C\u0004=\u0003W\u0003\u000b\u0011B\u0019\t\u0011\u0005m\u00121\u0016C\u0001\u0003w#R\u0001VA_\u0003\u007fC\u0001\"!\u0011\u0002:\u0002\u0007\u00111\t\u0005\t\u0003'\nI\f1\u0001\u0002V!2\u0011\u0011XAb\u0003\u0007\u0003R!CA1\u0003\u000b\u0004B!a\u001a\u0002H\u00129\u00111\u000e\u0001C\u0002\u00055\u0004\u0002CAf\u0003W#\t!!4\u0002#!\fg\u000e\u001a7f\t\u0006$\u0018\rR3mKR,G\rF\u0002U\u0003\u001fD\u0001\"!5\u0002J\u0002\u0007\u00111I\u0001\tI\u0006$\u0018\rU1uQ\"2\u0011\u0011ZAk\u0003\u0007\u0003R!CA1\u0003/\u0004B!a\u001a\u0002Z\u00129\u00111\u000e\u0001C\u0002\u00055\u0004\"CAo\u0001\u0001\u0007I\u0011BAp\u0003a!W\r\\3uKR{\u0007/[2t\u0019&\u001cH/\u001a8fe~#S-\u001d\u000b\u0004)\u0006\u0005\b\"\u0003-\u0002\\\u0006\u0005\t\u0019AAU\u0011!\t)\u000f\u0001Q!\n\u0005%\u0016!\u00063fY\u0016$X\rV8qS\u000e\u001cH*[:uK:,'\u000f\t\u0005\n\u0003S\u0004\u0001\u0019!C\u0005\u0003W\fQ#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH*[:uK:,'/\u0006\u0002\u0002nB1\u0011IRA\"\u0003_\u0004B!a\u0007\u0002r\u001a1\u00111\u001f\u0001\u0001\u0003k\u0014Q#\u00113e!\u0006\u0014H/\u001b;j_:\u001cH*[:uK:,'oE\u0004\u0002r\u0006\r\u0012q\u001f\b\u0011\u0007I\nI0C\u0002\u0002|N\u0012q\"\u0013.l\t\u0006$\u0018\rT5ti\u0016tWM\u001d\u0005\f\u0003\u007f\f\tP!A!\u0002\u0013\t\u0019%A\u0003u_BL7\rC\u0004\u001b\u0003c$\tAa\u0001\u0015\t\u0005=(Q\u0001\u0005\t\u0003\u007f\u0014\t\u00011\u0001\u0002D!A!\u0011BAy\t\u0003\u0011Y!\u0001\tiC:$G.\u001a#bi\u0006\u001c\u0005.\u00198hKR)AK!\u0004\u0003\u0010!A\u0011\u0011\u001bB\u0004\u0001\u0004\t\u0019\u0005\u0003\u0005\u0003\u0012\t\u001d\u0001\u0019AA\u0012\u0003\u0011!\u0017\r^1)\r\t\u001d!QCAB!\u0015I\u0011\u0011\rB\f!\u0011\t9G!\u0007\u0005\u000f\u0005-\u0004A1\u0001\u0002n!A\u00111ZAy\t\u0003\u0011i\u0002F\u0002U\u0005?A\u0001\"!\u0011\u0003\u001c\u0001\u0007\u00111\t\u0015\u0007\u00057\u0011\u0019#a!\u0011\u000b%\t\tG!\n\u0011\t\u0005\u001d$q\u0005\u0003\b\u0003W\u0002!\u0019AA7\u0011%\u0011Y\u0003\u0001a\u0001\n\u0013\u0011i#A\rbI\u0012\u0004\u0016M\u001d;ji&|gn\u001d'jgR,g.\u001a:`I\u0015\fHc\u0001+\u00030!I\u0001L!\u000b\u0002\u0002\u0003\u0007\u0011Q\u001e\u0005\t\u0005g\u0001\u0001\u0015)\u0003\u0002n\u00061\u0012\r\u001a3QCJ$\u0018\u000e^5p]Nd\u0015n\u001d;f]\u0016\u0014\b\u0005C\u0004\u00038\u0001!\tA!\u000f\u0002\u000fM$\u0018M\u001d;vaR\tA\u000bC\u0004\u0003>\u0001!\tA!\u000f\u0002#I,w-[:uKJd\u0015n\u001d;f]\u0016\u00148\u000fC\u0004\u0003B\u0001!\tA!\u000f\u0002\u0011MDW\u000f\u001e3po:DqA!\u0012\u0001\t\u0003\u0011I$A\u0011ue&<w-\u001a:P]2Lg.\u001a)beRLG/[8o'R\fG/Z\"iC:<W\rC\u0004\u0003J\u0001!\tAa\u0013\u0002#A\f'\u000f^5uS>t7/\u00138Ti\u0006$X\r\u0006\u0003\u0003N\tU\u0003#\u0002B(\u0005#BU\"\u0001#\n\u0007\tMCIA\u0002TKRDqAa\u0016\u0003H\u0001\u0007a*A\u0003ti\u0006$X\rC\u0004\u0003\\\u0001!\tA!\u0018\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\n)\n}#1\rB4\u0005cB\u0001B!\u0019\u0003Z\u0001\u0007!QJ\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bb\u0002B3\u00053\u0002\rAT\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\r\u0003\u0006\u0003j\te\u0003\u0013!a\u0001\u0005W\na\u0002\\3bI\u0016\u00148+\u001a7fGR|'\u000fE\u0002\u0017\u0005[J1Aa\u001c\u0003\u0005]\u0001\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'\u000f\u0003\u0006\u0003t\te\u0003\u0013!a\u0001\u0005k\n\u0011bY1mY\n\f7m[:\u0011\u0007Y\u00119(C\u0002\u0003z\t\u0011\u0011bQ1mY\n\f7m[:\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0000\u0005\t\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3\u0015\u0017Q\u0013\tIa!\u0003\b\n%%1\u0012\u0005\t\u0003\u007f\u0014Y\b1\u0001\u0002D!9!Q\u0011B>\u0001\u0004I\u0013!\u00039beRLG/[8o\u0011\u001d\u0011)Ga\u001fA\u00029C\u0001B!\u001b\u0003|\u0001\u0007!1\u000e\u0005\t\u0005g\u0012Y\b1\u0001\u0003v!9!q\u0012\u0001\u0005\n\te\u0012\u0001G5oSRL\u0017\r\\5{KB\u000b'\u000f^5uS>t7\u000b^1uK\"9!1\u0013\u0001\u0005\n\tU\u0015!G1tg\u0016\u0014HOV1mS\u0012\u0004&/\u001a<j_V\u001c8\u000b^1uKN$r\u0001\u0016BL\u00057\u0013)\u000bC\u0004\u0003\u001a\nE\u0005\u0019\u0001%\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0003\u001e\nE\u0005\u0019\u0001BP\u0003)1'o\\7Ti\u0006$Xm\u001d\t\u0006\u0005\u001f\u0012\tKT\u0005\u0004\u0005G#%aA*fc\"9!Q\rBI\u0001\u0004q\u0005b\u0002BU\u0001\u0011%!1V\u0001\u001bCN\u001c\u0018n\u001a8SKBd\u0017nY1t)>\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0006)\n5&q\u0016\u0005\t\u0003\u007f\u00149\u000b1\u0001\u0002D!9!Q\u0011BT\u0001\u0004I\u0003b\u0002BZ\u0001\u0011%!QW\u0001#S:LG/[1mSj,G*Z1eKJ\fe\u000eZ%te\u001a{'\u000fU1si&$\u0018n\u001c8\u0015\u0007Q\u00139\fC\u0004\u0003\u001a\nE\u0006\u0019\u0001%\t\u000f\tm\u0006\u0001\"\u0001\u0003>\u00069R\r\\3di2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\b)\n}&\u0011\u0019Bb\u0011!\tyP!/A\u0002\u0005\r\u0003b\u0002BC\u0005s\u0003\r!\u000b\u0005\t\u0005S\u0012I\f1\u0001\u0003l!9!q\u0019\u0001\u0005\n\t%\u0017a\u0007:fO&\u001cH/\u001a:U_BL7m\u00115b]\u001e,G*[:uK:,'\u000f\u0006\u0002\u0003LB1\u0011qKA-\u0005\u001b\u0004B!!\n\u0003P&!\u0011QJA\u0014\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0005+\fqD]3hSN$XM\u001d)beRLG/[8o\u0007\"\fgnZ3MSN$XM\\3s)\r!&q\u001b\u0005\t\u0003\u007f\u0014\t\u000e1\u0001\u0002D!9!1\u001c\u0001\u0005\u0002\tu\u0017!\t3fe\u0016<\u0017n\u001d;feB\u000b'\u000f^5uS>t7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014Hc\u0001+\u0003`\"A\u0011q Bm\u0001\u0004\t\u0019\u0005C\u0004\u0003d\u0002!IA!3\u00027I,w-[:uKJ$U\r\\3uKR{\u0007/[2MSN$XM\\3s\u0011\u001d\u00119\u000f\u0001C\u0005\u0005S\fAeZ3u\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ#q_\u000eDwJ\u001d+ie><X\t_2faRLwN\u001c\u000b\u0007\u0005W\u0014\tPa=\u0011\u0007Y\u0011i/C\u0002\u0003p\n\u00111\u0004T3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007\u0002CA\u0000\u0005K\u0004\r!a\u0011\t\u000f\t\u0015%Q\u001da\u0001S!I!q\u001f\u0001\u0012\u0002\u0013\u0005!\u0011`\u0001\u001dQ\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YP\u000b\u0003\u0003l\tu8F\u0001B\u0000!\u0011\u0019\taa\u0003\u000e\u0005\r\r!\u0002BB\u0003\u0007\u000f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r%!\"\u0001\u0006b]:|G/\u0019;j_:LAa!\u0004\u0004\u0004\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\rE\u0001!%A\u0005\u0002\rM\u0011\u0001\b5b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007+QCA!\u001e\u0003~\u0002")
public class PartitionStateMachine
implements Logging {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$PartitionStateMachine$$zkClient;
    private Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final Logger stateChangeLogger;
    private TopicChangeListener topicChangeListener;
    private DeleteTopicsListener deleteTopicsListener;
    private Map<String, AddPartitionsListener> addPartitionsListener;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public ZkClient kafka$controller$PartitionStateMachine$$zkClient() {
        return this.kafka$controller$PartitionStateMachine$$zkClient;
    }

    public Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    public void partitionState_$eq(Map<TopicAndPartition, PartitionState> x$1) {
        this.partitionState = x$1;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private TopicChangeListener topicChangeListener() {
        return this.topicChangeListener;
    }

    private void topicChangeListener_$eq(TopicChangeListener x$1) {
        this.topicChangeListener = x$1;
    }

    private DeleteTopicsListener deleteTopicsListener() {
        return this.deleteTopicsListener;
    }

    private void deleteTopicsListener_$eq(DeleteTopicsListener x$1) {
        this.deleteTopicsListener = x$1;
    }

    private Map<String, AddPartitionsListener> addPartitionsListener() {
        return this.addPartitionsListener;
    }

    private void addPartitionsListener_$eq(Map<String, AddPartitionsListener> x$1) {
        this.addPartitionsListener = x$1;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started partition state machine with initial state -> ").append((Object)this.$outer.partitionState().toString()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
        this.registerDeleteTopicListener();
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.partitionState().clear();
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.partitionState().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> check$ifrefutable$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> x$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        boolean bl = !this.$outer.kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion(topicAndPartition.topic());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final void apply(Tuple2<TopicAndPartition, PartitionState> x$2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$2;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        PartitionState partitionState = (PartitionState)tuple2._2();
                        if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                            this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, this.$outer.kafka$controller$PartitionStateMachine$$controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while moving some partitions to the online state";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.partitionState().filter((Function1)new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final PartitionState state$1;

            public final boolean apply(Tuple2<TopicAndPartition, PartitionState> p) {
                Object object = p._2();
                PartitionState partitionState = this.state$1;
                return !(object != null ? !object.equals(partitionState) : partitionState != null);
            }
            {
                this.state$1 = state$1;
            }
        })).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        this.info((Function0<String>)new Serializable(this, partitions, targetState){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final PartitionState targetState$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.partitions$1.mkString(",")}));
            }
            {
                this.partitions$1 = partitions$1;
                this.targetState$1 = targetState$1;
            }
        });
        try {
            this.brokerRequestBatch().newBatch();
            partitions.foreach((Function1)new Serializable(this, targetState, leaderSelector, callbacks){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final PartitionState targetState$1;
                private final PartitionLeaderSelector leaderSelector$1;
                private final Callbacks callbacks$1;

                public final void apply(TopicAndPartition topicAndPartition) {
                    this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), this.targetState$1, this.leaderSelector$1, this.callbacks$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.targetState$1 = targetState$1;
                    this.leaderSelector$1 = leaderSelector$1;
                    this.callbacks$1 = callbacks$1;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void kafka$controller$PartitionStateMachine$$handleStateChange(String topic, int partition, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, targetState})));
        PartitionState currState = (PartitionState)this.partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NonExistentPartition$ apply() {
                return NonExistentPartition$.MODULE$;
            }
        });
        try {
            PartitionState partitionState = targetState;
            NewPartition$ newPartition$ = NewPartition$.MODULE$;
            PartitionState partitionState2 = partitionState;
            if (!(newPartition$ != null ? !newPartition$.equals(partitionState2) : partitionState2 != null)) {
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                this.assignReplicasToPartitions(topic, partition);
                this.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                String assignedReplicas = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s with assigned replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState, assignedReplicas})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                PartitionState partitionState3 = partitionState;
                if (!(onlinePartition$ != null ? !onlinePartition$.equals(partitionState3) : partitionState3 != null)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState4 = (PartitionState)this.partitionState().apply((Object)topicAndPartition);
                    NewPartition$ newPartition$2 = NewPartition$.MODULE$;
                    PartitionState partitionState5 = partitionState4;
                    if (!(newPartition$2 != null ? !newPartition$2.equals(partitionState5) : partitionState5 != null)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                        PartitionState partitionState6 = partitionState4;
                        if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState6) : partitionState6 != null)) {
                            this.electLeaderForPartition(topic, partition, leaderSelector);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            OnlinePartition$ onlinePartition$2 = OnlinePartition$.MODULE$;
                            PartitionState partitionState7 = partitionState4;
                            if (!(onlinePartition$2 != null ? !onlinePartition$2.equals(partitionState7) : partitionState7 != null)) {
                                this.electLeaderForPartition(topic, partition, leaderSelector);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                    this.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int leader = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to %s with leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState, BoxesRunTime.boxToInteger((int)leader)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                    PartitionState partitionState8 = partitionState;
                    if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState8) : partitionState8 != null)) {
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState})));
                        this.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    } else {
                        NonExistentPartition$ nonExistentPartition$ = NonExistentPartition$.MODULE$;
                        PartitionState partitionState9 = partitionState;
                        if (nonExistentPartition$ != null ? !nonExistentPartition$.equals(partitionState9) : partitionState9 != null) throw new MatchError((Object)partitionState);
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState})));
                        this.partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState})), throwable);
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> check$ifrefutable$2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Option<PartitionState> apply(Tuple2<TopicAndPartition, Seq<Object>> x$3) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2;
                block2: {
                    Option option;
                    block8: {
                        Option option2;
                        block7: {
                            TopicAndPartition topicPartition;
                            block3: {
                                boolean bl;
                                block6: {
                                    Option option3;
                                    block5: {
                                        block4: {
                                            tuple2 = x$3;
                                            if (tuple2 == null) break block2;
                                            topicPartition = (TopicAndPartition)tuple2._1();
                                            option = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicPartition);
                                            if (!(option instanceof Some)) break block3;
                                            Some some = (Some)option;
                                            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            bl = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderIsrAndEpoch.leaderAndIsr().leader()));
                                            if (!bl) break block4;
                                            option3 = this.$outer.partitionState().put((Object)topicPartition, (Object)OnlinePartition$.MODULE$);
                                            break block5;
                                        }
                                        if (bl) break block6;
                                        option3 = this.$outer.partitionState().put((Object)topicPartition, (Object)OfflinePartition$.MODULE$);
                                    }
                                    option2 = option3;
                                    break block7;
                                }
                                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            }
                            None$ none$ = None$.MODULE$;
                            Option option4 = option;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block8;
                            option2 = this.$outer.partitionState().put((Object)topicPartition, (Object)NewPartition$.MODULE$);
                        }
                        Option option5 = option2;
                        return option5;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> fromStates, PartitionState targetState) {
        if (fromStates.contains(this.partitionState().apply((Object)topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, fromStates.mkString(","), targetState}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState().apply((Object)topicAndPartition)}))).toString());
    }

    private void assignReplicasToPartitions(String topic, int partition) {
        Seq<Object> assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), topic, partition);
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic, partition)), assignedReplicas));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        Seq replicaAssignment = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
        Seq liveAssignedReplicas = (Seq)replicaAssignment.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final boolean apply(int r) {
                return this.apply$mcZI$sp(r);
            }

            public boolean apply$mcZI$sp(int r) {
                return this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)r));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        int n = liveAssignedReplicas.size();
        switch (n) {
            default: {
                this.debug((Function0<String>)new Serializable(this, topicAndPartition, liveAssignedReplicas){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$1;
                    private final Seq liveAssignedReplicas$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Live assigned replicas for partition %s are: [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.liveAssignedReplicas$1}));
                    }
                    {
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.liveAssignedReplicas$1 = liveAssignedReplicas$1;
                    }
                });
                int leader = BoxesRunTime.unboxToInt((Object)liveAssignedReplicas.head());
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, (List<Object>)liveAssignedReplicas.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
                this.debug((Function0<String>)new Serializable(this, topicAndPartition, leaderIsrAndControllerEpoch){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$1;
                    private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Initializing leader and isr for partition %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.leaderIsrAndControllerEpoch$1}));
                    }
                    {
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch$1;
                    }
                });
                try {
                    ZkUtils$.MODULE$.createPersistentPath(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderIsrAndControllerEpoch.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()));
                    this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                    return;
                }
                catch (ZkNodeExistsException zkNodeExistsException) {
                    LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topicAndPartition.topic(), topicAndPartition.partition()).get();
                    String failMsg2 = new StringOps(Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndEpoch.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}));
                    this.stateChangeLogger().error((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)failMsg2).toString());
                    throw new StateChangeFailedException(failMsg2);
                }
            }
            case 0: 
        }
        String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, replicaAssignment.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
        this.stateChangeLogger().error((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)failMsg).toString());
        throw new StateChangeFailedException(failMsg);
    }

    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
        try {
            Seq replicasForThisPartition;
            LeaderAndIsr newLeaderAndIsr;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2;
                block7: {
                    Tuple2<Object, Object> tuple22;
                    boolean zookeeperPathUpdateSucceeded = false;
                    newLeaderAndIsr = null;
                    replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
                    while (true) {
                        Tuple2.mcZI.sp sp2;
                        Tuple2 tuple23;
                        if (zookeeperPathUpdateSucceeded) break block6;
                        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                        LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                        int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                        if (controllerEpoch > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String failMsg = new StringOps(Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)failMsg).toString());
                            throw new StateChangeFailedException(failMsg);
                        }
                        tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                        if (tuple2 == null) break block7;
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)leaderAndIsr, (Object)replicas);
                        LeaderAndIsr leaderAndIsr2 = (LeaderAndIsr)tuple24._1();
                        Seq replicas2 = (Seq)tuple24._2();
                        tuple22 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.kafka$controller$PartitionStateMachine$$zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderAndIsr2, this.kafka$controller$PartitionStateMachine$$controller.epoch()), currentLeaderAndIsr.zkVersion());
                        if (tuple22 == null) break;
                        boolean updateSucceeded = tuple22._1$mcZ$sp();
                        int newVersion = tuple22._2$mcI$sp();
                        Tuple2.mcZI.sp sp3 = sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
                        boolean updateSucceeded2 = sp3._1$mcZ$sp();
                        int newVersion2 = sp3._2$mcI$sp();
                        LeaderAndIsr leaderAndIsr3 = leaderAndIsr2;
                        leaderAndIsr3.zkVersion_$eq(newVersion2);
                        boolean bl = updateSucceeded2;
                        Seq seq = replicas2;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(newLeaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)newLeaderAndIsr.leader()), topicAndPartition})));
            Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (Throwable throwable) {
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, throwable.getMessage()}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)failMsg).toString());
            throw new StateChangeFailedException(failMsg, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
            // empty catch block
        }
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("After leader election, leader cache is updated to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> l) {
                        return new Tuple2(l._1(), l._2());
                    }
                }, Map$.MODULE$.canBuildFrom())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private java.util.List<String> registerTopicChangeListener() {
        this.topicChangeListener_$eq(new TopicChangeListener());
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    public void registerPartitionChangeListener(String topic) {
        this.addPartitionsListener().put((Object)topic, (Object)new AddPartitionsListener(this, topic));
        this.kafka$controller$PartitionStateMachine$$zkClient().subscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply((Object)topic));
    }

    public void deregisterPartitionChangeListener(String topic) {
        this.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply((Object)topic));
    }

    private java.util.List<String> registerDeleteTopicListener() {
        this.deleteTopicsListener_$eq(new DeleteTopicsListener());
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    /*
     * WARNING - void declaration
     */
    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topic, partition);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
            return leaderIsrAndControllerEpoch;
        }
        None$ none$ = None$.MODULE$;
        Option<LeaderIsrAndControllerEpoch> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            void var3_3;
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3, this.partitionState().apply((Object)var3_3)}));
            throw new StateChangeFailedException(failMsg);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController controller) {
        this.kafka$controller$PartitionStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkClient = this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.topicChangeListener = null;
        this.deleteTopicsListener = null;
        this.addPartitionsListener = Map$.MODULE$.empty();
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            TopicChangeListener topicChangeListener = this;
            synchronized (topicChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public void handleChildChange(String parentPath, java.util.List<String> children) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, parentPath, children){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicChangeListener $outer;
                public final String parentPath$1;
                public final java.util.List children$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$hasStarted().get()) {
                        try {
                            this.$outer.debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ TopicChangeListener$$anonfun$handleChildChange$1 $outer;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Topic change listener fired for path %s with children %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.$outer.children$1).mkString(",")}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            scala.collection.immutable.Set currentChildren = JavaConversions$.MODULE$.asScalaBuffer(this.children$1).toSet();
                            scala.collection.immutable.Set newTopics = (scala.collection.immutable.Set)currentChildren.$minus$minus(this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                            Set deletedTopics = (Set)this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().$minus$minus((GenTraversableOnce)currentChildren);
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics_$eq((Set<String>)currentChildren);
                            Map<TopicAndPartition, Seq<Object>> addedPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)newTopics.toSeq());
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment_$eq((Map<TopicAndPartition, Seq<Object>>)((Map)this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, deletedTopics){
                                public static final long serialVersionUID = 0L;
                                private final Set deletedTopics$1;

                                public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                                    return !this.deletedTopics$1.contains((Object)((TopicAndPartition)p._1()).topic());
                                }
                                {
                                    this.deletedTopics$1 = deletedTopics$1;
                                }
                            })));
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq(addedPartitionReplicaAssignment);
                            this.$outer.info((Function0<String>)new Serializable(this, newTopics, deletedTopics, addedPartitionReplicaAssignment){
                                public static final long serialVersionUID = 0L;
                                private final scala.collection.immutable.Set newTopics$1;
                                private final Set deletedTopics$1;
                                private final Map addedPartitionReplicaAssignment$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("New topics: [%s], deleted topics: [%s], new partition replica assignment [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopics$1, this.deletedTopics$1, this.addedPartitionReplicaAssignment$1}));
                                }
                                {
                                    this.newTopics$1 = newTopics$1;
                                    this.deletedTopics$1 = deletedTopics$1;
                                    this.addedPartitionReplicaAssignment$1 = addedPartitionReplicaAssignment$1;
                                }
                            });
                            if (newTopics.size() > 0) {
                                this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewTopicCreation((Set<String>)newTopics, (Set<TopicAndPartition>)addedPartitionReplicaAssignment.keySet().toSet());
                            }
                        }
                        catch (Throwable throwable) {
                            this.$outer.error((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Error while handling new topic";
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable){
                                public static final long serialVersionUID = 0L;
                                private final Throwable e$3;

                                public final Throwable apply() {
                                    return this.e$3;
                                }
                                {
                                    this.e$3 = e$3;
                                }
                            });
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.parentPath$1 = parentPath$1;
                    this.children$1 = children$1;
                }
            });
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public TopicChangeListener() {
            if (PartitionStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[TopicChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DeleteTopicsListener
    implements IZkChildListener,
    Logging {
        private final ZkClient zkClient;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            DeleteTopicsListener deleteTopicsListener = this;
            synchronized (deleteTopicsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public ZkClient zkClient() {
            return this.zkClient;
        }

        public void handleChildChange(String parentPath, java.util.List<String> children) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, children){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicsListener $outer;
                private final java.util.List children$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ObjectRef topicsToBeDeleted = new ObjectRef((Object)JavaConversions$.MODULE$.asScalaBuffer(this.children$2).toSet());
                    this.$outer.debug((Function0<String>)new Serializable(this, topicsToBeDeleted){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef topicsToBeDeleted$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Delete topics listener fired for topics %s to be deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((scala.collection.immutable.Set)this.topicsToBeDeleted$1.elem).mkString(",")}));
                        }
                        {
                            this.topicsToBeDeleted$1 = topicsToBeDeleted$1;
                        }
                    });
                    scala.collection.immutable.Set nonExistentTopics = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                        public final boolean apply(String t) {
                            return !this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().contains((Object)t);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (nonExistentTopics.size() > 0) {
                        this.$outer.warn((Function0<String>)new Serializable(this, nonExistentTopics){
                            public static final long serialVersionUID = 0L;
                            private final scala.collection.immutable.Set nonExistentTopics$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Ignoring request to delete non-existing topics ").append((Object)this.nonExistentTopics$1.mkString(",")).toString();
                            }
                            {
                                this.nonExistentTopics$1 = nonExistentTopics$1;
                            }
                        });
                        nonExistentTopics.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                            public final void apply(String topic) {
                                ZkUtils$.MODULE$.deletePathRecursive(this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(topic));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    topicsToBeDeleted.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).$minus$minus((GenTraversableOnce)nonExistentTopics);
                    if (((scala.collection.immutable.Set)topicsToBeDeleted.elem).size() > 0) {
                        this.$outer.info((Function0<String>)new Serializable(this, topicsToBeDeleted){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef topicsToBeDeleted$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Starting topic deletion for topics ").append((Object)((scala.collection.immutable.Set)this.topicsToBeDeleted$1.elem).mkString(",")).toString();
                            }
                            {
                                this.topicsToBeDeleted$1 = topicsToBeDeleted$1;
                            }
                        });
                        this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().enqueueTopicsForDeletion((Set<String>)((scala.collection.immutable.Set)topicsToBeDeleted.elem));
                        ((scala.collection.immutable.Set)topicsToBeDeleted.elem).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                            public final void apply(String topic) {
                                boolean preferredReplicaElectionInProgress = ((SetLike)this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsUndergoingPreferredReplicaElection().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(TopicAndPartition x$6) {
                                        return x$6.topic();
                                    }
                                }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                                boolean partitionReassignmentInProgress = ((SetLike)this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsBeingReassigned().keySet().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(TopicAndPartition x$7) {
                                        return x$7.topic();
                                    }
                                }, Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                                if (preferredReplicaElectionInProgress || partitionReassignmentInProgress) {
                                    this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }

                public /* synthetic */ DeleteTopicsListener kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.children$2 = children$2;
                }
            });
        }

        public void handleDataDeleted(String dataPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public DeleteTopicsListener() {
            if (PartitionStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[DeleteTopicsListener on ").append((Object)BoxesRunTime.boxToInteger((int)PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
            this.zkClient = PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class AddPartitionsListener
    implements IZkDataListener,
    Logging {
        public final String kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic;
        public final /* synthetic */ PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            AddPartitionsListener addPartitionsListener = this;
            synchronized (addPartitionsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public void handleDataChange(String dataPath, Object data) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, dataPath, data){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AddPartitionsListener $outer;
                public final String dataPath$1;
                public final Object data$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    try {
                        this.$outer.info((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ AddPartitionsListener$$anonfun$handleDataChange$1 $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Add Partition triggered ").append((Object)this.$outer.data$1.toString()).append((Object)" for path ").append((Object)this.$outer.dataPath$1).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        Map<TopicAndPartition, Seq<Object>> partitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic})));
                        Map partitionsToBeAdded = (Map)partitionReplicaAssignment.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ AddPartitionsListener$$anonfun$handleDataChange$1 $outer;

                            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                                return !this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().contains(p._1());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion(this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic)) {
                            this.$outer.error((Function0<String>)new Serializable(this, partitionsToBeAdded){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ AddPartitionsListener$$anonfun$handleDataChange$1 $outer;
                                private final Map partitionsToBeAdded$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Skipping adding partitions %s for topic %s since it is currently being deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.partitionsToBeAdded$1.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(Tuple2<TopicAndPartition, Seq<Object>> x$8) {
                                            return ((TopicAndPartition)x$8._1()).partition();
                                        }
                                    }, Iterable$.MODULE$.canBuildFrom())).mkString(","), this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.partitionsToBeAdded$1 = partitionsToBeAdded$1;
                                }
                            });
                        } else if (partitionsToBeAdded.size() > 0) {
                            this.$outer.info((Function0<String>)new Serializable(this, partitionsToBeAdded){
                                public static final long serialVersionUID = 0L;
                                private final Map partitionsToBeAdded$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("New partitions to be added %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeAdded$1}));
                                }
                                {
                                    this.partitionsToBeAdded$1 = partitionsToBeAdded$1;
                                }
                            });
                            this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewPartitionCreation((Set<TopicAndPartition>)partitionsToBeAdded.keySet().toSet());
                        }
                    }
                    catch (Throwable throwable) {
                        this.$outer.error((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ AddPartitionsListener$$anonfun$handleDataChange$1 $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Error while handling add partitions for data path ").append((Object)this.$outer.dataPath$1).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$4;

                            public final Throwable apply() {
                                return this.e$4;
                            }
                            {
                                this.e$4 = e$4;
                            }
                        });
                    }
                }

                public /* synthetic */ AddPartitionsListener kafka$controller$PartitionStateMachine$AddPartitionsListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.dataPath$1 = dataPath$1;
                    this.data$1 = data$1;
                }
            });
        }

        public void handleDataDeleted(String parentPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer() {
            return this.$outer;
        }

        public AddPartitionsListener(PartitionStateMachine $outer, String topic) {
            this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic = topic;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[AddPartitionsListener on ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

