/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

@Distributable
public class DNSResolutionMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(DNSResolutionMonitor.class);
    public static final String PARM_RESOLUTION_TYPE = "resolution-type";
    public static final String PARM_RESOLUTION_TYPE_V4 = "v4";
    public static final String PARM_RESOLUTION_TYPE_V6 = "v6";
    public static final String PARM_RESOLUTION_TYPE_BOTH = "both";
    public static final String PARM_RESOLUTION_TYPE_EITHER = "either";
    public static final String PARM_RESOLUTION_TYPE_DEFAULT = "either";
    public static final String PARM_NAMESERVER = "nameserver";

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        Object resolver;
        Name name;
        try {
            name = new Name(svc.getNodeLabel());
        }
        catch (TextParseException e) {
            return PollStatus.unavailable((String)("Invalid record name '" + svc.getNodeLabel() + "': " + e.getMessage()));
        }
        String resolutionType = ParameterMap.getKeyedString(parameters, (String)PARM_RESOLUTION_TYPE, (String)"either");
        boolean ipv4Required = PARM_RESOLUTION_TYPE_V4.equalsIgnoreCase(resolutionType) || PARM_RESOLUTION_TYPE_BOTH.equals(resolutionType);
        boolean ipv6Required = PARM_RESOLUTION_TYPE_V6.equalsIgnoreCase(resolutionType) || PARM_RESOLUTION_TYPE_BOTH.equals(resolutionType);
        String nameserver = ParameterMap.getKeyedString(parameters, (String)PARM_NAMESERVER, null);
        try {
            resolver = nameserver == null ? new ExtendedResolver() : new SimpleResolver(nameserver);
        }
        catch (UnknownHostException e) {
            return PollStatus.unavailable((String)("Unable to resolve nameserver '" + nameserver + "': " + e.getMessage()));
        }
        long start = System.currentTimeMillis();
        boolean ipv4Found = DNSResolutionMonitor.resolve(name, (Resolver)resolver, 1);
        boolean ipv6Found = DNSResolutionMonitor.resolve(name, (Resolver)resolver, 28);
        long end = System.currentTimeMillis();
        if (!ipv4Found && !ipv6Found) {
            return PollStatus.unavailable((String)("Unable to resolve host '" + name + "'"));
        }
        if (ipv4Required && !ipv4Found) {
            return PollStatus.unavailable((String)("'" + name + "' could be resolved to an IPv6 address (AAAA record) but not an IPv4 address (A record)"));
        }
        if (ipv6Required && !ipv6Found) {
            return PollStatus.unavailable((String)("'" + name + "' could be resolved to an IPv4 address (A record) but not an IPv6 address (AAAA record)"));
        }
        return PollStatus.available((Double)Double.valueOf(end - start));
    }

    private static boolean resolve(Name name, Resolver resolver, int type) {
        Lookup lookup = new Lookup(name, type);
        lookup.setResolver(resolver);
        Record[] records = lookup.run();
        if (records == null) {
            return false;
        }
        return Arrays.stream(records).filter(r -> r.getType() == type).count() > 0L;
    }
}

