/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.xml.MarshallingExceptionTranslator;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.xml.sax.InputSource;

public abstract class CastorUtils {
    private static final MarshallingExceptionTranslator CASTOR_EXCEPTION_TRANSLATOR = new MarshallingExceptionTranslator();
    private static final boolean DEFAULT_PRESERVATION_BEHAVIOR = false;

    public static void marshalWithTranslatedExceptions(Object obj, Writer writer) throws DataAccessException {
        try {
            CastorUtils.marshal(obj, writer);
        }
        catch (IOException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("marshalling XML file", e);
        }
        catch (MarshalException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("marshalling XML file", (Exception)((Object)e));
        }
        catch (ValidationException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("marshalling XML file", e);
        }
    }

    public static String marshal(Object obj) throws MarshalException, ValidationException, IOException {
        StringWriter writer = new StringWriter();
        CastorUtils.marshal(obj, writer);
        return writer.toString();
    }

    private static void marshal(Object obj, Writer writer) throws IOException, MarshalException, ValidationException {
        Marshaller m = new Marshaller(writer);
        m.setSuppressNamespaces(true);
        m.marshal(obj);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void marshalWithTranslatedExceptionsViaString(Object obj, Resource resource) throws DataAccessException {
        OutputStreamWriter fileWriter = null;
        try {
            StringWriter writer = new StringWriter();
            CastorUtils.marshal(obj, writer);
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(resource.getFile()), "UTF-8");
            fileWriter.write(writer.toString());
            ((Writer)fileWriter).flush();
        }
        catch (IOException e) {
            try {
                throw CASTOR_EXCEPTION_TRANSLATOR.translate("marshalling XML file", e);
                catch (MarshalException e2) {
                    throw CASTOR_EXCEPTION_TRANSLATOR.translate("marshalling XML file", (Exception)((Object)e2));
                }
                catch (ValidationException e3) {
                    throw CASTOR_EXCEPTION_TRANSLATOR.translate("marshalling XML file", e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    public static <T> Unmarshaller getUnmarshaller(Class<T> clazz) {
        return CastorUtils.createUnmarshaller(clazz, true);
    }

    private static <T> Unmarshaller createUnmarshaller(Class<T> clazz, boolean preserveWhitespace) {
        Unmarshaller u = new Unmarshaller(clazz);
        u.setIgnoreExtraAttributes(false);
        u.setIgnoreExtraElements(false);
        u.setWhitespacePreserve(preserveWhitespace);
        u.setProperty("org.exolab.castor.sax.features", "http://apache.org/xml/features/disallow-doctype-decl");
        u.setProperty("org.exolab.castor.sax.features-to-disable", "http://xml.org/sax/features/external-general-entities,http://xml.org/sax/features/external-parameter-entities,http://apache.org/xml/features/nonvalidating/load-external-dtd");
        return u;
    }

    public static <T> T unmarshal(Class<T> clazz, Reader reader) throws MarshalException, ValidationException {
        return CastorUtils.unmarshal(clazz, reader, false);
    }

    public static <T> T unmarshal(Class<T> clazz, Reader reader, boolean preserveWhitespace) throws MarshalException, ValidationException {
        return (T)CastorUtils.createUnmarshaller(clazz, preserveWhitespace).unmarshal(reader);
    }

    public static <T> T unmarshal(Class<T> clazz, InputStream in) throws MarshalException, ValidationException {
        return CastorUtils.unmarshal(clazz, new InputSource(in), false);
    }

    public static <T> T unmarshal(Class<T> clazz, InputStream in, boolean preserveWhitespace) throws MarshalException, ValidationException {
        return CastorUtils.unmarshal(clazz, new InputSource(in), preserveWhitespace);
    }

    private static <T> T unmarshal(Class<T> clazz, InputSource source, boolean preserveWhitespace) throws MarshalException, ValidationException {
        return (T)CastorUtils.createUnmarshaller(clazz, preserveWhitespace).unmarshal(source);
    }

    public static <T> T unmarshal(Class<T> clazz, Resource resource) throws MarshalException, ValidationException, IOException {
        return CastorUtils.unmarshal(clazz, resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshal(Class<T> clazz, Resource resource, boolean preserveWhitespace) throws MarshalException, ValidationException, IOException {
        InputStream in;
        try {
            in = resource.getInputStream();
        }
        catch (IOException e) {
            IOException newE = new IOException("Failed to open XML configuration file for resource '" + resource + "': " + e);
            newE.initCause(e);
            throw newE;
        }
        try {
            InputSource source = new InputSource(in);
            try {
                source.setSystemId(resource.getURL().toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            T t = CastorUtils.unmarshal(clazz, source, preserveWhitespace);
            return t;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, Reader reader) throws DataAccessException {
        return CastorUtils.unmarshalWithTranslatedExceptions(clazz, reader, false);
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, Reader reader, boolean preserveWhitespace) throws DataAccessException {
        try {
            return CastorUtils.unmarshal(clazz, reader, preserveWhitespace);
        }
        catch (MarshalException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("unmarshalling XML file", (Exception)((Object)e));
        }
        catch (ValidationException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("unmarshalling XML file", e);
        }
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, InputStream in) throws DataAccessException {
        return CastorUtils.unmarshalWithTranslatedExceptions(clazz, in, false);
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, InputStream in, boolean preserveWhitespace) throws DataAccessException {
        try {
            return CastorUtils.unmarshal(clazz, in);
        }
        catch (MarshalException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("unmarshalling XML file", (Exception)((Object)e));
        }
        catch (ValidationException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("unmarshalling XML file", e);
        }
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, Resource resource) {
        return CastorUtils.unmarshalWithTranslatedExceptions(clazz, resource, false);
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, Resource resource, boolean preserveWhitespace) {
        InputStream in;
        try {
            in = resource.getInputStream();
        }
        catch (IOException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("opening XML configuration file for resource '" + resource + "'", e);
        }
        try {
            InputSource source = new InputSource(in);
            try {
                source.setSystemId(resource.getURL().toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            T t = CastorUtils.unmarshal(clazz, source, preserveWhitespace);
            return t;
        }
        catch (MarshalException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("unmarshalling XML file for resource '" + resource + "'", (Exception)((Object)e));
        }
        catch (ValidationException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("unmarshalling XML file for resource '" + resource + "'", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static void marshalViaString(Object config, File cfgFile) throws MarshalException, ValidationException, IOException {
        StringWriter stringWriter = new StringWriter();
        CastorUtils.marshal(config, stringWriter);
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
        fileWriter.write(stringWriter.toString());
        ((Writer)fileWriter).flush();
        ((Writer)fileWriter).close();
    }

    public static void marshalViaString(Object config, Resource resource) throws MarshalException, ValidationException, IOException {
        CastorUtils.marshalViaString(config, resource.getFile());
    }

    public static <T> T duplicateObject(T object, Class<T> clazz) throws MarshalException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal(object, (Writer)stringWriter);
        StringReader stringReader = new StringReader(stringWriter.toString());
        return (T)Unmarshaller.unmarshal(clazz, (Reader)stringReader);
    }
}

