/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.XADataSource;
import org.opennms.core.db.DataSourceConfigurationFactory;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.opennmsDataSources.ConnectionPool;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.postgresql.xa.PGXADataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XADataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceFactory.class);
    private static DataSourceConfigurationFactory m_dataSourceConfigFactory;
    private static final Map<String, XADataSource> m_dataSources;

    public static synchronized void init(String dsName) {
        PGXADataSource xaDataSource;
        URI url;
        if (XADataSourceFactory.isLoaded(dsName)) {
            return;
        }
        JdbcDataSource ds = m_dataSourceConfigFactory.getJdbcDataSource(dsName);
        ConnectionPool pool = m_dataSourceConfigFactory.getConnectionPool();
        String urlString = ds.getUrl();
        if (urlString.startsWith("jdbc:")) {
            urlString = urlString.substring("jdbc:".length());
        }
        if ("postgresql".equalsIgnoreCase((url = URI.create(urlString)).getScheme())) {
            xaDataSource = new PGXADataSource();
            xaDataSource.setServerName(url.getHost());
            xaDataSource.setPortNumber(url.getPort());
            xaDataSource.setDatabaseName(ds.getDatabaseName());
            xaDataSource.setUser(ds.getUserName());
            xaDataSource.setPassword(ds.getPassword());
            if (pool != null) {
                if (pool.getLoginTimeout() > 0) {
                    xaDataSource.setLoginTimeout(pool.getLoginTimeout());
                }
                if (pool.getIdleTimeout() > 0) {
                    xaDataSource.setSocketTimeout(pool.getIdleTimeout());
                }
            }
        } else {
            throw new UnsupportedOperationException("Data source scheme not supported: " + url.getScheme());
        }
        XADataSourceFactory.setInstance(dsName, (XADataSource)xaDataSource);
    }

    private static synchronized boolean isLoaded(String dsName) {
        return m_dataSources.containsKey(dsName);
    }

    public static XADataSource getInstance() {
        return XADataSourceFactory.getInstance("opennms");
    }

    public static XADataSource getInstance(String name) {
        XADataSource dataSource = XADataSourceFactory.getXADataSource(name);
        if (dataSource == null) {
            throw new IllegalArgumentException("Unable to locate data source named " + name + ".  Does this need to be init'd?");
        }
        return dataSource;
    }

    public static void setInstance(XADataSource ds) {
        XADataSourceFactory.setInstance("opennms", ds);
    }

    public static synchronized void setInstance(String dsName, XADataSource singleton) {
        m_dataSources.put(dsName, singleton);
    }

    public static XADataSource getXADataSource() {
        return XADataSourceFactory.getXADataSource("opennms");
    }

    public static synchronized XADataSource getXADataSource(String dsName) {
        XADataSourceFactory.init(dsName);
        return m_dataSources.get(dsName);
    }

    public static synchronized void setDataSourceConfigurationFactory(DataSourceConfigurationFactory factory) {
        XADataSourceFactory.close();
        m_dataSourceConfigFactory = factory;
    }

    public static synchronized void close() {
    }

    static {
        try {
            m_dataSourceConfigFactory = new DataSourceConfigurationFactory(ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME));
        }
        catch (IOException e) {
            LOG.warn("Could not parse default data source configuration", (Throwable)e);
            m_dataSourceConfigFactory = null;
        }
        m_dataSources = new ConcurrentHashMap<String, XADataSource>();
    }
}

