/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel;

import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageProducer;
import org.opennms.core.ipc.sink.api.MessageProducerFactory;
import org.opennms.core.ipc.sink.api.SinkModule;

public class CamelRemoteMessageProducerFactory
implements MessageProducerFactory {
    @EndpointInject(uri="direct:sendMessage", context="sinkClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:sendMessage", context="sinkClient")
    private Endpoint endpoint;

    public <T extends Message> MessageProducer<T> getProducer(final SinkModule<T> module) {
        return new MessageProducer<T>(){

            public void send(T message) {
                JmsQueueNameFactory queueNameFactory = new JmsQueueNameFactory("Sink", module.getId());
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("JmsQueueName", queueNameFactory.getName());
                CamelRemoteMessageProducerFactory.this.template.sendBodyAndHeaders(CamelRemoteMessageProducerFactory.this.endpoint, (Object)module.marshal(message), headers);
            }
        };
    }
}

