/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security.nonstandard;

import java.io.Serializable;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivAES;
import org.snmp4j.smi.OctetString;

public abstract class PrivAESWith3DESKeyExtension
extends PrivAES {
    private static final LogAdapter logger = LogFactory.getLogger(PrivAESWith3DESKeyExtension.class);

    public PrivAESWith3DESKeyExtension(int keyBytes) {
        super(keyBytes);
    }

    @Override
    public byte[] extendShortKey(byte[] shortKey, OctetString password, byte[] engineID, AuthenticationProtocol authProtocol) {
        int copyBytes;
        byte[] extendedKey = new byte[this.getMinKeyLength()];
        System.arraycopy(shortKey, 0, extendedKey, 0, shortKey.length);
        byte[] key = new byte[this.getMinKeyLength()];
        System.arraycopy(shortKey, 0, key, 0, shortKey.length);
        for (int length = shortKey.length; length < this.getMinKeyLength(); length += copyBytes) {
            key = authProtocol.passwordToKey(new OctetString(key, 0, length), engineID);
            copyBytes = Math.min(this.getMinKeyLength() - length, authProtocol.getDigestLength());
            System.arraycopy(key, 0, extendedKey, length, copyBytes);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("AES nonstandard key extend produced key " + new OctetString(extendedKey).toHexString())));
        }
        return extendedKey;
    }
}

