/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import com.novell.ldap.rfc2251.RfcLDAPString;
import com.novell.ldap.rfc2251.RfcReferral;
import com.novell.ldap.rfc2251.RfcResponse;
import java.io.IOException;
import java.io.InputStream;

public class RfcIntermediateResponse
extends ASN1Sequence
implements RfcResponse {
    public static final int TAG_RESPONSE_NAME = 0;
    public static final int TAG_RESPONSE = 1;
    private int m_referralIndex;
    private int m_responseNameIndex;
    private int m_responseValueIndex;

    public RfcIntermediateResponse(ASN1Decoder aSN1Decoder, InputStream inputStream, int n) throws IOException {
        super(aSN1Decoder, inputStream, n);
        int n2 = 0;
        this.m_responseValueIndex = 0;
        this.m_responseNameIndex = 0;
        block4: for (n2 = this.size() >= 3 ? 3 : 0; n2 < this.size(); ++n2) {
            ASN1Tagged aSN1Tagged = (ASN1Tagged)this.get(n2);
            ASN1Identifier aSN1Identifier = aSN1Tagged.getIdentifier();
            switch (aSN1Identifier.getTag()) {
                case 0: {
                    this.set(n2, new RfcLDAPOID(((ASN1OctetString)aSN1Tagged.taggedValue()).byteValue()));
                    this.m_responseNameIndex = n2;
                    continue block4;
                }
                case 1: {
                    this.set(n2, aSN1Tagged.taggedValue());
                    this.m_responseValueIndex = n2;
                }
            }
        }
    }

    public final RfcLDAPOID getResponseName() {
        return this.m_responseNameIndex >= 0 ? (RfcLDAPOID)this.get(this.m_responseNameIndex) : null;
    }

    public final ASN1OctetString getResponse() {
        return this.m_responseValueIndex != 0 ? (ASN1OctetString)this.get(this.m_responseValueIndex) : null;
    }

    public final ASN1Identifier getIdentifier() {
        return new ASN1Identifier(1, true, 25);
    }

    public final ASN1Enumerated getResultCode() {
        if (this.size() > 3) {
            return (ASN1Enumerated)this.get(0);
        }
        return null;
    }

    public final RfcLDAPDN getMatchedDN() {
        if (this.size() > 3) {
            return new RfcLDAPDN(((ASN1OctetString)this.get(1)).byteValue());
        }
        return null;
    }

    public final RfcReferral getReferral() {
        return this.size() > 3 ? (RfcReferral)this.get(3) : null;
    }

    public final RfcLDAPString getErrorMessage() {
        if (this.size() > 3) {
            return new RfcLDAPString(((ASN1OctetString)this.get(2)).byteValue());
        }
        return null;
    }
}

