/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPObjectClassSchema
extends LDAPSchemaElement {
    String[] superiors;
    String[] required;
    String[] optional;
    int type = -1;
    public static final int ABSTRACT = 0;
    public static final int STRUCTURAL = 1;
    public static final int AUXILIARY = 2;

    public LDAPObjectClassSchema() {
        super(LDAPSchema.schemaTypeNames[1]);
    }

    public LDAPObjectClassSchema(String[] stringArray, String string, String[] stringArray2, String string2, String[] stringArray3, String[] stringArray4, int n, boolean bl) {
        super(LDAPSchema.schemaTypeNames[1]);
        this.names = (String[])stringArray.clone();
        this.oid = string;
        this.description = string2;
        this.type = n;
        this.obsolete = bl;
        if (stringArray2 != null) {
            this.superiors = (String[])stringArray2.clone();
        }
        if (stringArray3 != null) {
            this.required = (String[])stringArray3.clone();
        }
        if (stringArray4 != null) {
            this.optional = (String[])stringArray4.clone();
        }
        super.setValue(this.formatString());
    }

    public LDAPObjectClassSchema(String string) {
        super(LDAPSchema.schemaTypeNames[1]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getNames() != null) {
                this.names = (String[])schemaParser.getNames().clone();
            }
            if (schemaParser.getID() != null) {
                this.oid = schemaParser.getID();
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            this.obsolete = schemaParser.getObsolete();
            if (schemaParser.getRequired() != null) {
                this.required = (String[])schemaParser.getRequired().clone();
            }
            if (schemaParser.getOptional() != null) {
                this.optional = (String[])schemaParser.getOptional().clone();
            }
            if (schemaParser.getSuperiors() != null) {
                this.superiors = (String[])schemaParser.getSuperiors().clone();
            }
            this.type = schemaParser.getType();
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String[] getSuperiors() {
        return this.superiors;
    }

    public String[] getRequiredAttributes() {
        return this.required;
    }

    public String[] getOptionalAttributes() {
        return this.optional;
    }

    public int getType() {
        return this.type;
    }

    protected String formatString() {
        Enumeration enumeration;
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((stringArray = this.getSuperiors()) != null) {
            stringBuffer.append(" SUP ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if (this.getType() != -1) {
            if (this.getType() == 0) {
                stringBuffer.append(" ABSTRACT");
            } else if (this.getType() == 2) {
                stringBuffer.append(" AUXILIARY");
            } else if (this.getType() == 1) {
                stringBuffer.append(" STRUCTURAL");
            }
        }
        if ((stringArray = this.getRequiredAttributes()) != null) {
            stringBuffer.append(" MUST ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((stringArray = this.getOptionalAttributes()) != null) {
            stringBuffer.append(" MAY ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((enumeration = this.getQualifierNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                stringBuffer.append(" " + string2 + " ");
                String[] stringArray2 = this.getQualifier(string2);
                if (stringArray2 == null) continue;
                if (stringArray2.length > 1) {
                    stringBuffer.append("( ");
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("'" + stringArray2[i] + "'");
                }
                if (stringArray2.length <= 1) continue;
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream bufferedInputStream) throws IOException {
        LDAPObjectClassSchema lDAPObjectClassSchema = (LDAPObjectClassSchema)LDAPObjectClassSchema.readDSML(bufferedInputStream);
        this.oid = lDAPObjectClassSchema.getID();
        this.names = lDAPObjectClassSchema.getNames();
        this.description = lDAPObjectClassSchema.getDescription();
        this.obsolete = lDAPObjectClassSchema.isObsolete();
        Enumeration enumeration = lDAPObjectClassSchema.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = lDAPObjectClassSchema.getQualifier(string);
            this.setQualifier(string, stringArray);
        }
        super.setValue(this.formatString());
        this.superiors = lDAPObjectClassSchema.getSuperiors();
        this.required = lDAPObjectClassSchema.getRequiredAttributes();
        this.optional = lDAPObjectClassSchema.getOptionalAttributes();
        this.type = lDAPObjectClassSchema.getType();
        lDAPObjectClassSchema = null;
    }

    protected void writeValue(Writer writer) throws IOException {
        String string = this.formatString();
        writer.write(ValueXMLhandler.newLine(2));
        writer.write("<value>");
        writer.write(string);
        writer.write("</value>");
    }

    protected void writeValue(StringBuffer stringBuffer) {
        String string = this.formatString();
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("<value>");
        stringBuffer.append(string);
        stringBuffer.append("</value>");
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPObjectClassSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPObjectClassSchema)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPObjectClassSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPObjectClassSchema)this.valuelist.get(0));
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator iterator = this.valuelist.iterator();
                LDAPObjectClassSchema lDAPObjectClassSchema = new LDAPObjectClassSchema(this.attrName);
                byte[] byArray = (byte[])iterator.next();
                StringBuffer stringBuffer = new StringBuffer(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
                try {
                    SchemaParser schemaParser = new SchemaParser(stringBuffer.toString());
                    if (schemaParser.getNames() != null) {
                        lDAPObjectClassSchema.names = (String[])schemaParser.getNames().clone();
                    }
                    if (schemaParser.getID() != null) {
                        lDAPObjectClassSchema.oid = schemaParser.getID();
                    }
                    if (schemaParser.getDescription() != null) {
                        lDAPObjectClassSchema.description = schemaParser.getDescription();
                    }
                    lDAPObjectClassSchema.obsolete = schemaParser.getObsolete();
                    if (schemaParser.getRequired() != null) {
                        lDAPObjectClassSchema.required = (String[])schemaParser.getRequired().clone();
                    }
                    if (schemaParser.getOptional() != null) {
                        lDAPObjectClassSchema.optional = (String[])schemaParser.getOptional().clone();
                    }
                    if (schemaParser.getSuperiors() != null) {
                        lDAPObjectClassSchema.superiors = (String[])schemaParser.getSuperiors().clone();
                    }
                    lDAPObjectClassSchema.type = schemaParser.getType();
                    Enumeration enumeration = schemaParser.getQualifiers();
                    while (enumeration.hasMoreElements()) {
                        AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                        lDAPObjectClassSchema.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
                    }
                    lDAPObjectClassSchema.setValue(lDAPObjectClassSchema.formatString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
                this.setObject(lDAPObjectClassSchema);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }
}

